<?php
namespace Mainto\Bridge\Enums\Order\Order;

class OrderItemTypeEnum {
    /**
     * 正常拍摄产品的主产品
     */
    const PRODUCT = 'product';
    /**
     * 正常拍摄产品的升级服务
     */
    const SERVICE = 'service';
    /**
     * 增值属性(未使用)
     */
    const PRODUCT_ATTRIBUTE = 'product_attribute';
    /**
     * 打包产品的主产品
     */
    const PACKAGE_PRODUCT = 'package_product';
    /**
     * 打包产品的sku--对标product,实际为图库信息
     */
    const PACKAGE_SKU = 'package_sku';
    /**
     * 打包产品的升级服务--对标service
     */
    const PACKAGE_SERVICE = 'package_service';
    /**
     * 增值属性(未使用)
     */
    const PACKAGE_ATTRIBUTE = 'package_attribute';
    /**
     * 签到信息
     */
    const REACHED = 'reached';
    /**
     * 真实产品——主产品
     */
    const REAL_PRIMARY_PRODUCT_MAP = [0 => 'product',1 => 'package_product'];
    /**
     * 主产品
     */
    const PRIMARY_PRODUCT_MAP = [0 => 'product',1 => 'reached',2 => 'package_product'];
    /**
     * 升级服务以及sku信息
     */
    const SERVICE_WITH_SKU_MAP = [0 => 'service',1 => 'package_sku',2 => 'package_service'];
    /**
     * 升级服务
     */
    const PRIMARY_SERVICE_MAP = [0 => 'service',1 => 'package_service'];
    const PACKAGE_TYPE_LIST = [0 => 'package_product',1 => 'package_sku',2 => 'package_service',3 => 'package_attribute'];
}