<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setInputStaffByParams(array|\Mainto\Bridge\Structs\Order\Order\Command\DiffInputStaffCommand $params)
 * @method setDiffPaymentLinkByParams(array|\Mainto\Bridge\Structs\Order\Order\Command\DiffPaymentLinkCommand $params)
 * @method cleanDiffPaymentLinkByParams(array $params)
 * @method existPaymentLinkByParams(array $params)
 */
class OrderDiffV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 二销主推伙伴
     *
     * @var  \Mainto\Bridge\Structs\Order\Order\Command\DiffInputStaffCommand $diffInputStaffCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function setInputStaff (\Mainto\Bridge\Structs\Order\Order\Command\DiffInputStaffCommand $diffInputStaffCommand) {
        return self::getClass()->setInputStaff($diffInputStaffCommand);
    }


    /**
     * 设置支付信息
     *
     * @var  \Mainto\Bridge\Structs\Order\Order\Command\DiffPaymentLinkCommand $diffPaymentLinkCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function setDiffPaymentLink (\Mainto\Bridge\Structs\Order\Order\Command\DiffPaymentLinkCommand $diffPaymentLinkCommand) {
        return self::getClass()->setDiffPaymentLink($diffPaymentLinkCommand);
    }


    /**
     * 删除支付信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $orderDiffId orderDiffId [ require true ]
     * @param  int $operateId 操作人id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cleanDiffPaymentLink (int $orderId, int $orderDiffId, int $operateId) {
        return self::getClass()->cleanDiffPaymentLink([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 是否存在支付信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $orderDiffId orderDiffId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function existPaymentLink (int $orderId, int $orderDiffId) {
        return self::getClass()->existPaymentLink([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderDiffV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderDiffV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}