<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\CreateRefundGroupOrderCommand $params)
 * @method auditPassByParams(array $params)
 * @method auditRejectByParams(array $params)
 * @method refundRejectByParams(array|\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundRejectCommand $params)
 * @method refundSuccessByParams(array|\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundSuccessCommand $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundListCommand $params)
 * @method detailByParams(array $params)
 */
class RefundGroupOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退款
     *
     * @var  \Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\CreateRefundGroupOrderCommand $command
     * @throws  \Exception
     * @return  int
     */
    public static function create (\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\CreateRefundGroupOrderCommand $command) {
        return self::getClass()->create($command);
    }


    /**
     * 审核通过
     *
     * @param  int $refundGroupOrderId 团购订单退款id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function auditPass (int $refundGroupOrderId) {
        return self::getClass()->auditPass([
            "refundGroupOrderId" => $refundGroupOrderId,
        ]);
    }

    /**
     * 审核拒绝
     *
     * @param  int $refundGroupOrderId 团购订单退款id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function auditReject (int $refundGroupOrderId) {
        return self::getClass()->auditReject([
            "refundGroupOrderId" => $refundGroupOrderId,
        ]);
    }

    /**
     * 退款拒绝
     *
     * @var  \Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundRejectCommand $command
     * @throws  \Exception
     * @return  bool
     */
    public static function refundReject (\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundRejectCommand $command) {
        return self::getClass()->refundReject($command);
    }


    /**
     * 退款同意
     *
     * @var  \Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundSuccessCommand $command
     * @throws  \Exception
     * @return  bool
     */
    public static function refundSuccess (\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundSuccessCommand $command) {
        return self::getClass()->refundSuccess($command);
    }


    /**
     * 团购订单退款列表
     *
     * @var  \Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundListCommand $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\RefundGroupOrder\DTO\RefundListDTO
     */
    public static function list (\Mainto\Bridge\Structs\Order\RefundGroupOrder\Command\RefundListCommand $command) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($command),
            "\Mainto\Bridge\Structs\Order\RefundGroupOrder\DTO\RefundListDTO"
        );
    }


    /**
     * 团购订单退款单详情
     *
     * @param  int $refundGroupOrderId 团购订单退款id [ require true ]
     * @param  bool $withDeleted 需要查询已删除 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\RefundGroupOrder\DTO\RefundDetailDTO
     */
    public static function detail (int $refundGroupOrderId, bool $withDeleted = false) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "refundGroupOrderId" => $refundGroupOrderId,
                            "withDeleted" => $withDeleted,
                        ]),
            "\Mainto\Bridge\Structs\Order\RefundGroupOrder\DTO\RefundDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'RefundGroupOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'RefundGroupOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}