<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method closePaymentAwayOrderByParams(array $params)
 * @method closeOrderProductCardByParams(array $params)
 * @method batchCloseOrderProductCardByParams(array|\Mainto\Bridge\Structs\Order\Order\Command\BatchCloseOrderProductCardCommand $params)
 * @method orderInfoByParams(array $params)
 */
class OrderV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 关闭网关支付订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closePaymentAwayOrder (int $id, string $reason, int $operateId) {
        return self::getClass()->closePaymentAwayOrder([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 关闭订单的产品卡信息
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $productCardId 产品卡id [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeOrderProductCard (int $id, int $productCardId, string $reason, int $operateId) {
        return self::getClass()->closeOrderProductCard([
            "id" => $id,
            "productCardId" => $productCardId,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量关闭订单的产品卡信息
     *
     * @var  \Mainto\Bridge\Structs\Order\Order\Command\BatchCloseOrderProductCardCommand $batchCloseOrderProductCard
     * @throws  \Exception
     * @return  array
     */
    public static function batchCloseOrderProductCard (\Mainto\Bridge\Structs\Order\Order\Command\BatchCloseOrderProductCardCommand $batchCloseOrderProductCard) {
        return self::getClass()->batchCloseOrderProductCard($batchCloseOrderProductCard);
    }


    /**
     * 获取订单信息（现包含支付等信息用于财务中台核算处理）
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\Order\DTO\Info\OrderInfoDTO
     */
    public static function orderInfo (string $orderNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderInfo([
                            "orderNo" => $orderNo,
                        ]),
            "\Mainto\Bridge\Structs\Order\Order\DTO\Info\OrderInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}