<?php
namespace Mainto\Bridge\Invokes\Order\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderSaleCounterByParams(array|\Mainto\Bridge\Structs\Order\MessageHook\Command\OrderSaleCounterCommand $params)
 */
class OrderSale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 监听 order:order_sales ，暂时不用
     *
     * @var  \Mainto\Bridge\Structs\Order\MessageHook\Command\OrderSaleCounterCommand $orderSaleCounterCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function orderSaleCounter (\Mainto\Bridge\Structs\Order\MessageHook\Command\OrderSaleCounterCommand $orderSaleCounterCommand) {
        return self::getClass()->orderSaleCounter($orderSaleCounterCommand);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'MessageHook\OrderSale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'MessageHook\OrderSale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}