<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method getListByRefundIdsByParams(array $params)
 * @method changeRefundAccountByParams(array $params)
 */
class RefundChange {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建转退
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  string $people 转退人姓名 [ require true ]
     * @param  string $account 转退账户 [ require true ]
     * @param  string $reason 转退原因 [ require true ]
     * @param  int $inputStaffId 录入人伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (int $refundId, string $people, string $account, string $reason, int $inputStaffId) {
        return self::getClass()->create([
            "refundId" => $refundId,
            "people" => $people,
            "account" => $account,
            "reason" => $reason,
            "inputStaffId" => $inputStaffId,
        ]);
    }

    /**
     * 删除转退
     *
     * @param  int $id 转退ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 转退列表
     *
     * @support  int $orderId 主订单ID [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $statusList 状态列表 [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  int $userId 用户id [ require false ]
     * @support  array $storeIds 门店列表 [ require false ]
     * @support  string $createdAtStart 创建时间-开始 [ require false ]
     * @support  string $createdAtEnd 创建时间-结束 [ require false ]
     * @support  string $passedAtStart 通过时间-开始 [ require false ]
     * @support  string $passedAtEnd 通过时间-结束 [ require false ]
     * @support  int $page  [ require false ]
     * @support  int $pageSize  [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 转退详情
     *
     * @param  int $id 转退ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 通过转退
     *
     * @param  int $id 转退ID [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass (int $id, int $operateId) {
        return self::getClass()->pass([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 拒绝转退
     *
     * @param  int $id 转退ID [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @param  string $reason 拒绝原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reject (int $id, int $operateId, string $reason = '') {
        return self::getClass()->reject([
            "id" => $id,
            "operateId" => $operateId,
            "reason" => $reason,
        ]);
    }

    /**
     * 批量获取转退列表
     *
     * @param  array $refundIds 退款ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getListByRefundIds (array $refundIds) {
        return self::getClass()->getListByRefundIds([
            "refundIds" => $refundIds,
        ]);
    }

    /**
     * 修改转退账户信息
     *
     * @param  int $id 转退申请id [ require true ]
     * @param  string $people 退款人 [ require true ]
     * @param  string $account 退款账户 [ require true ]
     * @param  string $reason 退款原因 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeRefundAccount (int $id, string $people, string $account, string $reason) {
        return self::getClass()->changeRefundAccount([
            "id" => $id,
            "people" => $people,
            "account" => $account,
            "reason" => $reason,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'RefundChange');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'RefundChange');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}