<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method existDiscountRulesByParams(array|\Mainto\Bridge\Structs\Order\Order\Command\Search\ExistDiscountRuleCommand $params)
 * @method orderPaymentInfoByParams(array $params)
 */
class OrderSearch {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 是否存在优惠规则
     *
     * @var  \Mainto\Bridge\Structs\Order\Order\Command\Search\ExistDiscountRuleCommand $existDiscountRuleCommand
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\Order\DTO\Search\ExistDiscountRuleDTO
     */
    public static function existDiscountRules (\Mainto\Bridge\Structs\Order\Order\Command\Search\ExistDiscountRuleCommand $existDiscountRuleCommand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->existDiscountRules($existDiscountRuleCommand),
            "\Mainto\Bridge\Structs\Order\Order\DTO\Search\ExistDiscountRuleDTO"
        );
    }


    /**
     * 订单的金额详情
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderPaymentInfo (int $orderId) {
        return self::getClass()->orderPaymentInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order\OrderSearch');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order\OrderSearch');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}