<?php
namespace Mainto\Bridge\Invokes\Order\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setOrderExpressByParams(array|\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressCreateCommand $params)
 * @method orderExistExpressByParams(array $params)
 * @method cleanOrderExpressByParams(array $params)
 * @method updateOrderExpressByParams(array|\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressUpdateCommand $params)
 * @method expressInfoByParams(array $params)
 * @method updateStatusByParams(array|\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressStatusCommand $params)
 */
class Express {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置快递信息
     *
     * @var  \Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressCreateCommand $expressCreateCommand
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\Order\DTO\Express\OrderExpressDTO
     */
    public static function setOrderExpress (\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressCreateCommand $expressCreateCommand) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->setOrderExpress($expressCreateCommand),
            "\Mainto\Bridge\Structs\Order\Order\DTO\Express\OrderExpressDTO"
        );
    }


    /**
     * 判断是否存在
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $expressNo 快递编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderExistExpress (int $orderId, string $expressNo) {
        return self::getClass()->orderExistExpress([
            "orderId" => $orderId,
            "expressNo" => $expressNo,
        ]);
    }

    /**
     * 清除快递信息
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $expressNo 快递编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cleanOrderExpress (int $orderId, string $expressNo) {
        return self::getClass()->cleanOrderExpress([
            "orderId" => $orderId,
            "expressNo" => $expressNo,
        ]);
    }

    /**
     * 更新订单快递信息
     *
     * @var  \Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressUpdateCommand $expressUpdateCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function updateOrderExpress (\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressUpdateCommand $expressUpdateCommand) {
        return self::getClass()->updateOrderExpress($expressUpdateCommand);
    }


    /**
     * 获取快递信息
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $expressNo 快递编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\Order\Order\DTO\Express\OrderExpressDTO
     */
    public static function expressInfo (int $orderId, string $expressNo) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->expressInfo([
                            "orderId" => $orderId,
                            "expressNo" => $expressNo,
                        ]),
            "\Mainto\Bridge\Structs\Order\Order\DTO\Express\OrderExpressDTO"
        );
    }

    /**
     * 更新订单快递信息
     *
     * @var  \Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressStatusCommand $expressStatusCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStatus (\Mainto\Bridge\Structs\Order\Order\Command\ExpressCommon\ExpressStatusCommand $expressStatusCommand) {
        return self::getClass()->updateStatus($expressStatusCommand);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order\Express');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order\Express');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}