<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method closeByParams(array $params)
 * @method cancelByParams(array $params)
 */
class DebugOfflineOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 关闭OT订单及流水信息
     *
     * @support  int $id ot订单id [ require true ]
     * @support  string $reason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close () {
        return self::getClass()->close([
        ]);
    }

    /**
     * 取消OT订单及流水信息
     *
     * @support  int $id ot订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancel () {
        return self::getClass()->cancel([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'DebugOfflineOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'DebugOfflineOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}