<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method changeOrderStatusByParams(array $params)
 */
class Fix {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 该接口修改订单状态，但是仅限于修复某些特殊情况.
     * 该操作只会简单改变订单数据的状态，而不处理状态变更相应的逻辑
     *
     * @support  string $order_no 订单号 [ require false ]
     * @support  int $id 订单ID [ require false ]
     * @support  string $status 订单状态 [ require true ]
     * @support  string $closed_at 订单关闭时间（仅在修改为退款关闭时有用） [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderStatus () {
        return self::getClass()->changeOrderStatus([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Fix');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Fix');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}