<?php
namespace Mainto\Bridge\Enums\Order\OrderExpress\s;

class ExpressStatusEnum {
    /**
     * 待揽收
     */
    const CONSIGN = 'consign';
    /**
     * 已揽件
     */
    const ACCEPT = 'accept';
    /**
     * 运输中
     */
    const TRANSPORT = 'transport';
    /**
     * 派送中
     */
    const DELIVERING = 'delivering';
    /**
     * 退货
     */
    const RETURN = 'return';
    /**
     * 包裹异常
     */
    const FAILED = 'failed';
    /**
     * 拒收
     */
    const REJECT = 'reject';
    /**
     * 已签收
     */
    const FINISH = 'finish';
    const ALL_EXPRESS_STATUS_MAP = [0 => 'consign',1 => 'accept',2 => 'transport',3 => 'delivering',4 => 'return',5 => 'failed',6 => 'reject',7 => 'finish'];
    const FINISHED_STATUS_MAP = [0 => 'reject',1 => 'finish'];
}