<?php
namespace Mainto\Bridge\Enums\Order\Order;

class OrderSaleSkuStatusEnum {
    /**
     * 未提交
     */
    const NO_SUBMIT = 'no_submit';
    /**
     * 已提交待支付（废弃）
     */
    const SUBMITTED = 'submitted';
    const PAID = 'paid';
    /**
     * 已取消（废弃）
     */
    const CANCELED = 'canceled';
    /**
     * 关闭
     */
    const CLOSED = 'closed';
    /**
     * 退款关闭
     */
    const CLOSED_BY_REFUND = 'closed_by_refund';
    /**
     * 转门店关闭
     */
    const CLOSED_BY_TURN_OUT = 'closed_by_turn_out';
    /**
     * 部分付款【缦图专用】
     */
    const PARTIAL_PAID = 'partial_paid';
    /**
     * 修改拍摄产品关闭
     */
    const CLOSE_BY_MODIFY = 'close_by_modify';
    /**
     * 重拍关闭
     */
    const CLOSE_BY_RETAKE = 'close_by_retake';
    /**
     * 部分支付
     */
    const PARTIAL_PAYMENT = 'partial_payment';
    const UN_PAID_STATUS_MAP = [0 => 'closed',1 => 'canceled',2 => 'close_by_modify',3 => 'closed_by_refund',4 => 'closed_by_turn_out'];
    const CONT_MODIFY_STATUS = [0 => 'closed',1 => 'close_by_modify',2 => 'closed_by_refund',3 => 'closed_by_turn_out'];
    const PAID_STATUS_MAP = [0 => 'paid',1 => 'partial_paid',2 => 'partial_payment'];
    const UN_REFUND_CLOSED_STATUS = [0 => 'closed',1 => 'canceled',2 => 'close_by_modify',3 => 'closed_by_turn_out'];
    const REMOVE_STATUS_MAP = [0 => 'no_submit',1 => 'closed',2 => 'canceled',3 => 'close_by_modify',4 => 'closed_by_refund',5 => 'closed_by_turn_out'];
}