<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method closeOvertimeOrderByParams(array $params)
 */
class DebugOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取销售数据接口
     *
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @param  bool $ignoreReserveTime 忽略预约时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function closeOvertimeOrder (string $startTime, string $endTime, bool $ignoreReserveTime) {
        return self::getClass()->closeOvertimeOrder([
            "startTime" => $startTime,
            "endTime" => $endTime,
            "ignoreReserveTime" => $ignoreReserveTime,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'DebugOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'DebugOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}