<?php
namespace Mainto\Bridge\Invokes\Order\OrderSaleCounter;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreOrderSalesByParams(array|\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $params)
 * @method getProductOrderSalesByParams(array|\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $params)
 * @method getReserveTimeOrderSalesByParams(array|\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $params)
 * @method getAllOrderSalesByParams(array|\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $params)
 * @method initOrderSalesByParams(array $params)
 * @method removeOrderSalesByParams(array $params)
 */
class OrderSaleCounter {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店销售数据计数器
     *
     * @var  \Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreOrderSales (\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand) {
        return self::getClass()->getStoreOrderSales($orderSaleSearchCommand);
    }


    /**
     * 产品销售数据计数器
     *
     * @var  \Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductOrderSales (\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand) {
        return self::getClass()->getProductOrderSales($orderSaleSearchCommand);
    }


    /**
     * 销售时间数据计数器
     *
     * @var  \Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReserveTimeOrderSales (\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand) {
        return self::getClass()->getReserveTimeOrderSales($orderSaleSearchCommand);
    }


    /**
     * 获取销售数据
     *
     * @var  \Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllOrderSales (\Mainto\Bridge\Structs\Order\OrderSaleCounter\Command\OrderSaleSearchCommand $orderSaleSearchCommand) {
        return self::getClass()->getAllOrderSales($orderSaleSearchCommand);
    }


    /**
     * 初始化订单销售信息
     *
     * @param  string $startReserveTime 开始时间 [ require false ]
     * @param  string $endReserveTime 结束时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function initOrderSales (string $startReserveTime = null, string $endReserveTime = null) {
        return self::getClass()->initOrderSales([
            "startReserveTime" => $startReserveTime,
            "endReserveTime" => $endReserveTime,
        ]);
    }

    /**
     * 删除订单销售信息
     *
     * @param  string $startReserveTime 开始时间 [ require false ]
     * @param  string $endReserveTime 结束时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeOrderSales (string $startReserveTime = null, string $endReserveTime = null) {
        return self::getClass()->removeOrderSales([
            "startReserveTime" => $startReserveTime,
            "endReserveTime" => $endReserveTime,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderSaleCounter\OrderSaleCounter');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderSaleCounter\OrderSaleCounter');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}