<?php
namespace Mainto\Bridge\Invokes\Order\Refund;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method calcRefundInfoByOrderItemsByParams(array|CalcRefund\CalcRefundInfoByOrderItems\CalcRefundCommand $params)
 */
class CalcRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据订单的拍摄产品获取可退信息
     *
     * @var  CalcRefund\CalcRefundInfoByOrderItems\CalcRefundCommand $command $command
     * @throws  \Exception
     * @return  CalcRefund\CalcRefundInfoByOrderItems\CalcRefundDTO
     */
    public static function calcRefundInfoByOrderItems (CalcRefund\CalcRefundInfoByOrderItems\CalcRefundCommand $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->calcRefundInfoByOrderItems($command),
            "\Mainto\Bridge\Invokes\Order\Refund\CalcRefund\CalcRefundInfoByOrderItems\CalcRefundDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Refund\CalcRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Refund\CalcRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}