<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|RefundDomain\Create\CreateRefundCommand $params)
 * @method passByParams(array $params)
 */
class RefundDomain {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退款
     *
     * @var  RefundDomain\Create\CreateRefundCommand $command $command
     * @throws  \Exception
     * @return  int
     */
    public static function create (RefundDomain\Create\CreateRefundCommand $command) {
        return self::getClass()->create($command);
    }


    /**
     * 通过退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass (int $id) {
        return self::getClass()->pass([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'RefundDomain');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'RefundDomain');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}