<?php
namespace Mainto\Bridge\Enums\Order;

class RpcMessageQueueEnum {
    /**
     * 取消订单
     */
    const ORDER_CANCEL_ORDER = 'order:cancel_order';
    /**
     * 订单支付
     */
    const ORDER_PAID_ORDER = 'order:paid_order';
    /**
     * 修改订单信息
     */
    const ORDER_MODIFY_ORDER_SALE = 'order:modify_order_sale';
    /**
     * 订单升级服务
     */
    const ORDER_ORDER_UPGRADE_SKU = 'order:order_upgrade_sku';
    /**
     * 恢复到等待拍摄
     */
    const ORDER_RECOVER_WAIT_SHOOTING = 'order.recover_wait_shooting';
    /**
     * 关闭部分订单,设置最终信息
     */
    const ORDER_PART_REFUND_SET_NEW_SKU = 'order.part_refund_set_new_sku';
    /**
     * 订单全部退款通知
     */
    const ORDER_REFUND_ORDER = 'order:refund_order';
    /**
     * 订单的重拍信息
     */
    const ORDER_RETAKE_ORDER_SALE_SKU = 'order:order_retake_sale_sku';
    /**
     * 取消重拍订单
     */
    const ORDER_CANCEL_RETAKE_ORDER = 'order:cancel_retake_order';
    /**
     * 订单——绑定用户
     */
    const ORDER_BIND_USER = 'order:bind_user';
    /**
     * 订单——解绑用户
     */
    const ORDER_UNBIND_USER = 'order:unbind_user';
    /**
     * 订单——转门店
     */
    const ORDER_CHANGE_STORE = 'order:change_store';
    /**
     * 订单——删除订单
     */
    const ORDER_DELETE_ORDER = 'order:delete_order';
    /**
     * 订单——作废产品卡
     */
    const ORDER_INVALID_PRODUCT_CARD = 'order:invalid_product_card';
    /**
     * 无纸化关单
     */
    const ORDER_PAPERLESS_CLOSE_ORDER = 'paperless.close_order';
    /**
     * 订单——完成服务
     */
    const ORDER_SERVICE_COMPLETE_SKU = 'order:order_service_completed';
    /**
     * 添加用户积分
     */
    const ORDER_CREATE_USER_FLOW = 'order:create_user_flow';
    /**
     * 订单完成之后的优惠券通知事件
     */
    const ORDER_COUPON_USER_FLOW = 'order:create_coupon_user_flow';
    /**
     * 订单完成之后的退款的优惠券通知事件
     */
    const ORDER_COUPON_REFUND_USER_FLOW = 'order:create_coupon_refund_user_flow';
    /**
     * 用户重拍
     */
    const ORDER_RETAKE_USER_FLOW = 'order:retake_user_flow';
    /**
     * 神策——设置支付事件
     */
    const ORDER_SENSORS_PAID = 'order:sensors.order_paid';
    /**
     * 神策——设置修改拍摄产品支付事件
     */
    const ORDER_SENSORS_UPDATE_PAID = 'order:sensors.order_update_paid';
    /**
     * 神策——设置升级服务支付事件
     */
    const ORDER_SENSORS_UPGRADE_PAID = 'order:sensors.order_upgrade_paid';
    /**
     * 神策——设置取消事件
     */
    const ORDER_SENSORS_CANCEL = 'order:sensors.order_cancel';
    /**
     * 神策——设置退款事件
     */
    const ORDER_SENSORS_REFUND = 'order:sensors.order_refund';
    /**
     * 神策——服务完成事件
     */
    const ORDER_SENSORS_SERVICE_COMPLETE = 'order:sensors.order_service_complete';
}