<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method detailByProductCardIdByParams(array $params)
 * @method getPreferentialByCardIdsByParams(array $params)
 * @method paidByParams(array $params)
 * @method cancelByParams(array $params)
 * @method reviewByParams(array $params)
 * @method balanceEntryByParams(array $params)
 * @method getPhotoOrdersByParams(array $params)
 * @method getAllOrderIdsByParams(array $params)
 * @method OrderProductByParams(array $params)
 * @method deleteOrderProductByParams(array $params)
 * @method getOrderProductByParams(array $params)
 * @method addPreferentialByParams(array $params)
 * @method decrementLeftNumByParams(array $params)
 * @method updateTemplateIdByParams(array $params)
 * @method addInvoiceInfoByParams(array $params)
 * @method finishPreferentialOrderByParams(array $params)
 * @method getGroupOrderInfoByOrderIdByParams(array $params)
 * @method getGroupOrderListByPayByParams(array $params)
 * @method cancelOrdersByParams(array $params)
 * @method closeOrdersByParams(array $params)
 */
class GroupOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 团购订单列表
     *
     * @support  string $business_name 企业名称 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  string $user_name 联系人 [ require false ]
     * @support  string $user_phone 手机号 [ require false ]
     * @support  array $order_ids 订单ids [ require false ]
     * @support  array $order_nos 订单号 [ require false ]
     * @support  array $status 订单状态 [ require false ]
     * @support  int $store_id 门店id [ require false ]
     * @support  int $is_private_pay 是否垫付(-1:非垫付，1：垫付) [ require false ]
     * @support  int $is_installment 是否分期(-1:全款，1：分期) [ require false ]
     * @support  string $installment_status 分期付款状态 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 创建订单
     *
     * @support  string $businessName 企业名称 [ require true ]
     * @support  string $userName 联系人 [ require true ]
     * @support  string $userPhone 手机号 [ require true ]
     * @support  string $email 邮箱 [ require true ]
     * @support  array $detail 团购产品信息 [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  string $note 预约信息备注 [ require false ]
     * @support  bool $isInstallment 是否分期 [ require false ]
     * @support  bool $isPrivatePay 是否垫付（私人付款） [ require false ]
     * @support  float $money 订单金额 [ require true ]
     * @support  float $payMoney 实付金额 [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  float $discount 折扣 [ require false ]
     * @support  float $downPaymentMoney 首付金额 [ require false ]
     * @support  float $balancePaymentMoney 尾款金额 [ require false ]
     * @support  float $outsideShotMoney 外拍金额 [ require false ]
     * @support  string $privateUserName 垫付人姓名 [ require false ]
     * @support  string $privateUserPhone 垫付人电话 [ require false ]
     * @support  int $inputStaffId 录入人 [ require true ]
     * @support  array $extend 扩展信息 [ require false ]
     * @support  string $channel 团购渠道 [ require true ]
     * @support  array $packageDiscountIds 套餐优惠信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单详情
     *
     * @support  string $order_no 订单no [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByNo () {
        return self::getClass()->detailByNo([
        ]);
    }

    /**
     * 根据产品卡id获取团购订单详情
     *
     * @support  int $card_id 产品卡id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detailByProductCardId () {
        return self::getClass()->detailByProductCardId([
        ]);
    }

    /**
     * 根据产品卡ids获取团购券码信息
     *
     * @support  array $card_ids 产品卡ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPreferentialByCardIds () {
        return self::getClass()->getPreferentialByCardIds([
        ]);
    }

    /**
     * 订单支付（全款与首款）
     *
     * @param  int $id 订单id [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  float $money 金额 [ require true ]
     * @param  string $paid_at 打款时间 [ require true ]
     * @param  string $payment_no 支付流水号 [ require false ]
     * @param  array $certificates 支付凭证 [ require false ]
     * @param  string $type 付款类型（全款，首款，尾款） [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paid (int $id, string $pay_type, string $paid_at, float $money, string $payment_no = '', string $type = '', array $certificates = []) {
        return self::getClass()->paid([
            "id" => $id,
            "pay_type" => $pay_type,
            "paid_at" => $paid_at,
            "money" => $money,
            "payment_no" => $payment_no,
            "type" => $type,
            "certificates" => $certificates,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $id) {
        return self::getClass()->cancel([
            "id" => $id,
        ]);
    }

    /**
     * 订单审核
     *
     * @param  int $pay_id 支付id [ require true ]
     * @param  string $action 通过和拒绝 pass|reject [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function review (int $pay_id, string $action) {
        return self::getClass()->review([
            "pay_id" => $pay_id,
            "action" => $action,
        ]);
    }

    /**
     * 支付尾款
     *
     * @support  float $money 尾款金额 [ require true ]
     * @support  array $detail 产品详情 [ require false ]
     * @support  int $order_id 订单id [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  string $paid_at 打款时间 [ require true ]
     * @support  bool $is_change 尾款是否变动 [ require false ]
     * @support  string $payment_no 支付流水号 [ require false ]
     * @support  array $certificates 支付凭证 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function balanceEntry () {
        return self::getClass()->balanceEntry([
        ]);
    }

    /**
     * 获取关联拍摄订单
     *
     * @support  int $group_order_id 团购订单id [ require true ]
     * @support  array $order_ids 订单ids [ require false ]
     * @support  array $order_nos 订单ids [ require false ]
     * @support  string $user_name 下单用户 [ require false ]
     * @support  string $user_phone 手机号 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPhotoOrders () {
        return self::getClass()->getPhotoOrders([
        ]);
    }

    /**
     * 获取所有团购关联订单id
     *
     * @param  int $store_id 门店id [ require false ]
     * @param  bool $with_del 是否包含删除 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllOrderIds (int $store_id = 0, bool $with_del = false) {
        return self::getClass()->getAllOrderIds([
            "store_id" => $store_id,
            "with_del" => $with_del,
        ]);
    }

    /**
     * 获取预约产品
     *
     * @param  int $id 预约产品信息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function OrderProduct (int $id) {
        return self::getClass()->OrderProduct([
            "id" => $id,
        ]);
    }

    /**
     * 删除预约产品
     *
     * @param  int $id 预约产品信息id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrderProduct (int $id) {
        return self::getClass()->deleteOrderProduct([
            "id" => $id,
        ]);
    }

    /**
     * 获取订单预约产品
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderProduct (int $order_id) {
        return self::getClass()->getOrderProduct([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 添加团购券码
     *
     * @support  array $card_ids 券码ids [ require true ]
     * @support  int $id 团购订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPreferential () {
        return self::getClass()->addPreferential([
        ]);
    }

    /**
     * 减少原始产品的剩余数量
     *
     * @support  int $item_id item id [ require true ]
     * @support  int $num 减去的值 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function decrementLeftNum () {
        return self::getClass()->decrementLeftNum([
        ]);
    }

    /**
     * 更新团购item的优惠模板id
     *
     * @support  int $item_id item id [ require true ]
     * @support  int $template_id 模板id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateTemplateId () {
        return self::getClass()->updateTemplateId([
        ]);
    }

    /**
     * 增加团购单开票信息
     *
     * @param  string $order_no 团购订单号 [ require true ]
     * @param  int $invoice_id 发票id [ require true ]
     * @param  float $money 金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addInvoiceInfo (string $order_no, int $invoice_id, float $money) {
        return self::getClass()->addInvoiceInfo([
            "order_no" => $order_no,
            "invoice_id" => $invoice_id,
            "money" => $money,
        ]);
    }

    /**
     * 完成订单
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishPreferentialOrder (int $id) {
        return self::getClass()->finishPreferentialOrder([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单ID获取团购拍摄订单信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupOrderInfoByOrderId (int $order_id) {
        return self::getClass()->getGroupOrderInfoByOrderId([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 根据支付信息获取团购订单列表
     *
     * @support  string $pay_type 支付类型，同子订单支付类型 [ require false ]
     * @support  string $paid_at_start 支付时间开始 [ require false ]
     * @support  string $paid_at_end 支付时间结束 [ require false ]
     * @support  int $store_id 门店ID [ require false ]
     * @support  string $channel 团购渠道 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupOrderListByPay () {
        return self::getClass()->getGroupOrderListByPay([
        ]);
    }

    /**
     * 批量取消订单
     *
     * @param  array $ids 订单ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelOrders (array $ids) {
        return self::getClass()->cancelOrders([
            "ids" => $ids,
        ]);
    }

    /**
     * 关闭未提取的团购订单
     *
     * @param  array $ids 订单ids [ require true ]
     * @param  string $reason 关闭原因 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrders (array $ids, string $reason = '') {
        return self::getClass()->closeOrders([
            "ids" => $ids,
            "reason" => $reason,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'GroupOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'GroupOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}