<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderTurnoverNumByPayTypeByParams(array $params)
 * @method changeStaffByParams(array|TurnoverV2\ChangeStaff\TurnoverInputStaffCommand $params)
 */
class TurnoverV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取拍摄订单的流水类型数量
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  bool $withDelete 是否包含删除的订单 [ require true ]
     * @param  array $payTypeList 流水类型: App\Interfaces\Order\Enums\TurnoverPayTypeEnum [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getOrderTurnoverNumByPayType (int $orderId, bool $withDelete = false, array $payTypeList) {
        return self::getClass()->getOrderTurnoverNumByPayType([
            "orderId" => $orderId,
            "withDelete" => $withDelete,
            "payTypeList" => $payTypeList,
        ]);
    }

    /**
     * 编辑二销主推伙伴
     *
     * @var  TurnoverV2\ChangeStaff\TurnoverInputStaffCommand $turnoverInputStaffCommand $turnoverInputStaffCommand
     * @throws  \Exception
     * @return  bool
     */
    public static function changeStaff (TurnoverV2\ChangeStaff\TurnoverInputStaffCommand $turnoverInputStaffCommand) {
        return self::getClass()->changeStaff($turnoverInputStaffCommand);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'TurnoverV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'TurnoverV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}