<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|RefundV2\Create\CreateRefundCommand $params)
 * @method confirmRefundSuccessByParams(array $params)
 * @method confirmRefundListSuccessByParams(array $params)
 * @method confirmRefundErrorByParams(array $params)
 * @method confirmRefundListErrorByParams(array $params)
 * @method confirmManualRefundPassByParams(array $params)
 * @method confirmManualRefundListPassByParams(array $params)
 * @method manualRefundPassByParams(array $params)
 * @method manualRefundListPassByParams(array $params)
 */
class RefundV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退款
     *
     * @var  RefundV2\Create\CreateRefundCommand $command $command
     * @throws  \Exception
     * @return  int
     */
    public static function create (RefundV2\Create\CreateRefundCommand $command) {
        return self::getClass()->create($command);
    }


    /**
     * 退款存疑数据通过
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  int $refundMoneyDetailId 退款存疑id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmRefundSuccess (int $refundId, int $refundMoneyDetailId) {
        return self::getClass()->confirmRefundSuccess([
            "refundId" => $refundId,
            "refundMoneyDetailId" => $refundMoneyDetailId,
        ]);
    }

    /**
     * 退款存疑数据批量通过
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  array $refundMoneyDetailIds 退款存疑id数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmRefundListSuccess (int $refundId, array $refundMoneyDetailIds) {
        return self::getClass()->confirmRefundListSuccess([
            "refundId" => $refundId,
            "refundMoneyDetailIds" => $refundMoneyDetailIds,
        ]);
    }

    /**
     * 退款存疑数据确认退款失败
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  int $refundMoneyDetailId 退款存疑id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmRefundError (int $refundId, int $refundMoneyDetailId) {
        return self::getClass()->confirmRefundError([
            "refundId" => $refundId,
            "refundMoneyDetailId" => $refundMoneyDetailId,
        ]);
    }

    /**
     * 退款存疑数据批量确认退款失败
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  array $refundMoneyDetailIds 退款存疑id数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmRefundListError (int $refundId, array $refundMoneyDetailIds) {
        return self::getClass()->confirmRefundListError([
            "refundId" => $refundId,
            "refundMoneyDetailIds" => $refundMoneyDetailIds,
        ]);
    }

    /**
     * 退款存疑的数据手动退款成功
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  int $refundMoneyDetailId 退款存疑id [ require true ]
     * @param  string $paymentNo 退款的支付编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmManualRefundPass (int $refundId, int $refundMoneyDetailId, string $paymentNo) {
        return self::getClass()->confirmManualRefundPass([
            "refundId" => $refundId,
            "refundMoneyDetailId" => $refundMoneyDetailId,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 退款存疑的数据手动退款成功批量设置
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  array $refundMoneyDetailIds 退款存疑id数组 [ require true ]
     * @param  string $paymentNo 退款的支付编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function confirmManualRefundListPass (int $refundId, array $refundMoneyDetailIds, string $paymentNo) {
        return self::getClass()->confirmManualRefundListPass([
            "refundId" => $refundId,
            "refundMoneyDetailIds" => $refundMoneyDetailIds,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 手动退款成功
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  int $refundMoneyDetailId 待退款的订单详情id [ require true ]
     * @param  string $paymentNo 退款的支付编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function manualRefundPass (int $refundId, int $refundMoneyDetailId, string $paymentNo) {
        return self::getClass()->manualRefundPass([
            "refundId" => $refundId,
            "refundMoneyDetailId" => $refundMoneyDetailId,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 手动退款批量操作成功
     *
     * @param  int $refundId 退款id [ require true ]
     * @param  array $refundMoneyDetailIds 待退款的订单详情id数组 [ require true ]
     * @param  string $paymentNo 退款的支付编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function manualRefundListPass (int $refundId, array $refundMoneyDetailIds, string $paymentNo) {
        return self::getClass()->manualRefundListPass([
            "refundId" => $refundId,
            "refundMoneyDetailIds" => $refundMoneyDetailIds,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'RefundV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'RefundV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}