<?php
namespace Mainto\Bridge\Invokes\Order\AfterSaleOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReasonsByParams(array $params)
 * @method getUserStatisticsByParams(array $params)
 * @method getStoreStatisticsByParams(array $params)
 * @method createByParams(array|AfterSaleOrder\Create\CreateCommand $params)
 * @method updateByParams(array|AfterSaleOrder\Update\UpdateCommand $params)
 * @method detailByParams(array $params)
 * @method createEvaluationByParams(array $params)
 */
class AfterSaleOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取补偿申请原因
     *
     * @throws  \Exception
     * @return  AfterSaleOrder\GetReasons\ReasonTreeDTO[]
     */
    public static function getReasons () {
        return self::getClass()->getReasons();
    }

    /**
     * 获取用户售后统计数据
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  AfterSaleOrder\GetUserStatistics\UserStatisticsDTO
     */
    public static function getUserStatistics (int $userId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getUserStatistics([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\GetUserStatistics\UserStatisticsDTO"
        );
    }

    /**
     * 获取门店售后统计数据
     *
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  AfterSaleOrder\GetStoreStatistics\StoreStatisticsDTO
     */
    public static function getStoreStatistics (int $storeId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getStoreStatistics([
                            "storeId" => $storeId,
                        ]),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\GetStoreStatistics\StoreStatisticsDTO"
        );
    }

    /**
     * 提交售后申请单
     *
     * @var  AfterSaleOrder\Create\CreateCommand $createCommand $createCommand
     * @throws  \Exception
     * @return  AfterSaleOrder\Create\AfterSaleOrderDTO
     */
    public static function create (AfterSaleOrder\Create\CreateCommand $createCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->create($createCommand),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\Create\AfterSaleOrderDTO"
        );
    }


    /**
     * 更新售后单状态
     *
     * @var  AfterSaleOrder\Update\UpdateCommand $updateCommand $updateCommand
     * @throws  \Exception
     * @return  AfterSaleOrder\Update\AfterSaleOrderDTO
     */
    public static function update (AfterSaleOrder\Update\UpdateCommand $updateCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->update($updateCommand),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\Update\AfterSaleOrderDTO"
        );
    }


    /**
     * 获取售后单详情
     *
     * @param  int $id 售后单id [ require true ]
     * @throws  \Exception
     * @return  AfterSaleOrder\Detail\AfterSaleOrderDTO
     */
    public static function detail (int $id) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\Detail\AfterSaleOrderDTO"
        );
    }

    /**
     * 售后评价
     *
     * @throws  \Exception
     * @return  AfterSaleOrder\CreateEvaluation\EvaluationDTO
     */
    public static function createEvaluation () {
        return self::getClass()->createEvaluation();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'AfterSaleOrder\AfterSaleOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'AfterSaleOrder\AfterSaleOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}