<?php
namespace Mainto\Bridge\Invokes\Order\AfterSaleOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReasonsByParams(array $params)
 * @method getUserStatisticsByParams(array $params)
 * @method getStoreStatisticsByParams(array $params)
 * @method getOrderStatisticsByParams(array $params)
 * @method createByParams(array|AfterSaleOrder\Create\CreateCommand $params)
 * @method updateByParams(array|AfterSaleOrder\Update\UpdateCommand $params)
 * @method detailByParams(array $params)
 * @method createEvaluationByParams(array|AfterSaleOrder\CreateEvaluation\CreateEvalutionCommand $params)
 * @method listByParams(array|AfterSaleOrder\ListSafeNamespace\ListCommand $params)
 * @method isAlreadyCreateAfterSaleByParams(array $params)
 * @method getAfterSaleByOrderIdByParams(array $params)
 * @method allByParams(array|AfterSaleOrder\All\AllCommand $params)
 */
class AfterSaleOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取补偿申请原因
     *
     * @param  string $type 售后单类型 [ require true ]
     * @throws  \Exception
     * @return  AfterSaleOrder\GetReasons\ReasonTreeDTO[]
     */
    public static function getReasons (string $type = 'preferential') {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getReasons([
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\GetReasons\ReasonTreeDTO[]"
        );
    }

    /**
     * 获取用户售后统计数据
     *
     * @param  int $userId 用户id [ require true ]
     * @param  string $type 售后单类型 [ require true ]
     * @throws  \Exception
     * @return  AfterSaleOrder\GetUserStatistics\UserStatisticsDTO
     */
    public static function getUserStatistics (int $userId, string $type = 'preferential') {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getUserStatistics([
                            "userId" => $userId,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\GetUserStatistics\UserStatisticsDTO"
        );
    }

    /**
     * 获取门店售后统计数据
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  string $type 售后单类型 [ require true ]
     * @throws  \Exception
     * @return  AfterSaleOrder\GetStoreStatistics\StoreStatisticsDTO
     */
    public static function getStoreStatistics (int $storeId, string $type = 'preferential') {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getStoreStatistics([
                            "storeId" => $storeId,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\GetStoreStatistics\StoreStatisticsDTO"
        );
    }

    /**
     * 获取订单售后统计数据
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getOrderStatistics (int $orderId, string $type = 'preferential') {
        return self::getClass()->getOrderStatistics([
            "orderId" => $orderId,
            "type" => $type,
        ]);
    }

    /**
     * 提交售后申请单
     *
     * @var  AfterSaleOrder\Create\CreateCommand $createCommand $createCommand
     * @throws  \Exception
     * @return  AfterSaleOrder\Create\AfterSaleOrderDTO
     */
    public static function create (AfterSaleOrder\Create\CreateCommand $createCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->create($createCommand),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\Create\AfterSaleOrderDTO"
        );
    }


    /**
     * 更新售后单状态
     *
     * @var  AfterSaleOrder\Update\UpdateCommand $updateCommand $updateCommand
     * @throws  \Exception
     * @return  AfterSaleOrder\Update\AfterSaleOrderDTO
     */
    public static function update (AfterSaleOrder\Update\UpdateCommand $updateCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->update($updateCommand),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\Update\AfterSaleOrderDTO"
        );
    }


    /**
     * 获取售后单详情
     *
     * @param  int $id 售后单id [ require true ]
     * @throws  \Exception
     * @return  AfterSaleOrder\Detail\AfterSaleOrderDTO
     */
    public static function detail (int $id) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\Detail\AfterSaleOrderDTO"
        );
    }

    /**
     * 售后评价
     *
     * @var  AfterSaleOrder\CreateEvaluation\CreateEvalutionCommand $createEvalutionCommand $createEvalutionCommand
     * @throws  \Exception
     * @return  AfterSaleOrder\CreateEvaluation\EvaluationDTO
     */
    public static function createEvaluation (AfterSaleOrder\CreateEvaluation\CreateEvalutionCommand $createEvalutionCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->createEvaluation($createEvalutionCommand),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\CreateEvaluation\EvaluationDTO"
        );
    }


    /**
     * 售后单列表
     *
     * @var  AfterSaleOrder\ListSafeNamespace\ListCommand $listCommand $listCommand
     * @throws  \Exception
     * @return  AfterSaleOrder\ListSafeNamespace\ListDTO
     */
    public static function list (AfterSaleOrder\ListSafeNamespace\ListCommand $listCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($listCommand),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\ListSafeNamespace\ListDTO"
        );
    }


    /**
     * 判断是否已存在售后单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function isAlreadyCreateAfterSale (int $orderId, string $type = 'preferential') {
        return self::getClass()->isAlreadyCreateAfterSale([
            "orderId" => $orderId,
            "type" => $type,
        ]);
    }

    /**
     * 使用海马体订单查询存在的售后单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 售后单类型 [ require true ]
     * @throws  \Exception
     * @return  AfterSaleOrder\GetAfterSaleByOrderId\AfterSaleOrderDTO
     */
    public static function getAfterSaleByOrderId (int $orderId, string $type = 'preferential') {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getAfterSaleByOrderId([
                            "orderId" => $orderId,
                            "type" => $type,
                        ]),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\GetAfterSaleByOrderId\AfterSaleOrderDTO"
        );
    }

    /**
     * 根据订单ids查询售后单
     *
     * @var  AfterSaleOrder\All\AllCommand $allCommand $allCommand
     * @throws  \Exception
     * @return  AfterSaleOrder\All\AfterSaleOrderDTO[]
     */
    public static function all (AfterSaleOrder\All\AllCommand $allCommand) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->all($allCommand),
            "\Mainto\Bridge\Invokes\Order\AfterSaleOrder\AfterSaleOrder\All\AfterSaleOrderDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'AfterSaleOrder\AfterSaleOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'AfterSaleOrder\AfterSaleOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}