<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method serviceCompleteByParams(array $params)
 * @method setLookPhotoCompleteByParams(array $params)
 * @method clearLookPhotoCompletedAtByParams(array $params)
 * @method listByParams(array $params)
 * @method removeByParams(array $params)
 * @method getOrderSaleSkusNameByParams(array $params)
 * @method closeMantuOrderSaleSkuByParams(array $params)
 * @method updateUserSexByParams(array $params)
 */
class OrderSaleSku {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 服务完成
     *
     * @param  int $id id [ require true ]
     * @param  array $ids ids [ require true ]
     * @param  bool $isUserComplete 是否是用户确认 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function serviceComplete (int $id = null, array $ids = null, bool $isUserComplete = true) {
        return self::getClass()->serviceComplete([
            "id" => $id,
            "ids" => $ids,
            "isUserComplete" => $isUserComplete,
        ]);
    }

    /**
     * 标识拍摄产品看片完成，根据type判断是否是自动完成看片，并做相关的操作
     *
     * @param  int $id id [ require true ]
     * @param  array $ids ids [ require true ]
     * @param  string $type 完成看片类型:auto,user [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setLookPhotoComplete (int $id = null, array $ids = null, string $type = 'user') {
        return self::getClass()->setLookPhotoComplete([
            "id" => $id,
            "ids" => $ids,
            "type" => $type,
        ]);
    }

    /**
     * 只清除自动看片的标识，可以再次看片
     *
     * @param  int $id 订单id [ require true ]
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearLookPhotoCompletedAt (int $id = null, array $ids = null) {
        return self::getClass()->clearLookPhotoCompletedAt([
            "id" => $id,
            "ids" => $ids,
        ]);
    }

    /**
     * 页面——查账助手
     *
     * @support  int $storeId 门店ID require false
     * @support  string $orderType 订单类型 require false
     * @support  string $type 子订单类型：order,ds require false
     * @support  string $status 状态 require false
     * @support  array $statusList 状态列表 require false
     * @support  string $payType 支付类型，同子订单支付类型 require false
     * @support  string $paidAtStart 支付时间起始 [ require true ]
     * @support  string $paidAtEnd 支付时间结束 [ require true ]
     * @support  string $pageSize 条数 require false
     * @support  string $page 页码 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除拍摄产品
     *
     * @param  int $id 拍摄产品订单的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取拍摄产品的名称
     *
     * @param  array $ids 拍摄产品订单的ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderSaleSkusName (array $ids) {
        return self::getClass()->getOrderSaleSkusName([
            "ids" => $ids,
        ]);
    }

    /**
     * 【缦图专用】
     *
     * @param  int $id 拍摄产品订单的id [ require true ]
     * @param  array $ids 拍摄产品订单的ids [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMantuOrderSaleSku (int $operateId, int $id = null, array $ids = null, string $reason = '') {
        return self::getClass()->closeMantuOrderSaleSku([
            "operateId" => $operateId,
            "id" => $id,
            "ids" => $ids,
            "reason" => $reason,
        ]);
    }

    /**
     * 更改拍摄产品性别
     *
     * @param  int $orderSaleSkuId 拍摄产品id [ require true ]
     * @param  array $orderSaleSkuIds 拍摄产品ids [ require true ]
     * @param  string $userSex 性别 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUserSex (int $orderSaleSkuId = null, array $orderSaleSkuIds = null, string $userSex = 'mix') {
        return self::getClass()->updateUserSex([
            "orderSaleSkuId" => $orderSaleSkuId,
            "orderSaleSkuIds" => $orderSaleSkuIds,
            "userSex" => $userSex,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderSaleSku');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderSaleSku');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}