<?php
namespace Mainto\Bridge\Invokes\Order\App\Interfaces\AfterSaleOrder\Controllers;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReasonsByParams(array $params)
 * @method getUserStatisticsByParams(array $params)
 * @method getStoreStatisticsByParams(array $params)
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method createEvaluationByParams(array $params)
 */
class AfterSaleOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取补偿申请原因
     *
     * @throws  \Exception
     * @return  AfterSaleOrder\GetReasons\ReasonDTO[]
     */
    public static function getReasons () {
        return self::getClass()->getReasons();
    }

    /**
     * 获取用户售后统计数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserStatistics () {
        return self::getClass()->getUserStatistics();
    }

    /**
     * 获取门店售后统计数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreStatistics () {
        return self::getClass()->getStoreStatistics();
    }

    /**
     * 提交售后申请单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取售后单详情
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 售后评价
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function createEvaluation () {
        return self::getClass()->createEvaluation();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'AfterSaleOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'AfterSaleOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}