<?php
namespace Mainto\Bridge\Enums\Order;

class OrderStatusEnum {
    /**
     * 未提交
     */
    const NO_SUBMIT = 'no_submit';
    /**
     * 已提交
     */
    const SUBMITTED = 'submitted';
    /**
     * 已取消
     */
    const CANCELED = 'canceled';
    /**
     * 等待拍摄
     */
    const WAIT_SHOOTING = 'wait_shooting';
    /**
     * 拍摄进行中
     */
    const WORKING = 'working';
    /**
     * 拍摄完成
     */
    const FINISHED = 'finished';
    /**
     * 服务完成（用户确认，服务整体完成，可进入收入确认状态）
     */
    const SERVICE_COMPLETED = 'service_completed';
    /**
     * 已关闭
     */
    const CLOSED = 'closed';
    /**
     * 退款关闭
     */
    const CLOSED_BY_REFUND = 'closed_by_refund';
    /**
     * 转门店关闭
     */
    const CLOSED_BY_TURN_OUT = 'closed_by_turn_out';
    /**
     * 以下状态订单禁止关闭
     */
    const CANT_CLOSE_STATUS = [0 => 'closed_by_refund',1 => 'closed',2 => 'closed_by_turn_out',3 => 'no_submit',4 => 'canceled',5 => 'finished',6 => 'service_completed'];
    /**
     * 美团订单以下状态订单禁止关闭
     */
    const CANT_CLOSE_MEITUAN_STATUS = [0 => 'closed_by_refund',1 => 'closed',2 => 'closed_by_turn_out',3 => 'no_submit',4 => 'canceled'];
    /**
     * 可以修改预约时间的状态
     */
    const CAN_CHANGE_RESERVE_TIME_STATUS = [0 => 'submitted',1 => 'wait_shooting',2 => 'working'];
    const MUST_FULL_REFUND_STATUS = [0 => 'wait_shooting',1 => 'working',2 => 'canceled',3 => 'submitted',4 => 'closed'];
    /**
     * 以下状态订单禁止关闭
     */
    const CANT_REFUND_STATUS = [0 => 'closed_by_refund',1 => 'closed',2 => 'closed_by_turn_out',3 => 'no_submit',4 => 'canceled'];
    const ORDER_FINISH_STATUS = [0 => 'finished',1 => 'service_completed'];
}