<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getBaseRetakeInfoByParams(array $params)
 * @method getBaseRetakeInfoListByOrderIdsByParams(array $params)
 * @method getBaseRetakeInfoListByRetakeOrderIdsByParams(array $params)
 * @method cancelByParams(array $params)
 * @method reasonOptionsByParams(array $params)
 * @method reasonDetailByParams(array $params)
 */
class OrderRetake {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * retakeSkuIds：所有的重拍的sku，包含所选择主产品和升级服务
     *
     * @support  int $orderId 重拍的订单id [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $peopleNum 订单到店人数（重拍商品的最大人数） [ require true ]
     * @support  float $money 订单金额 [ require true ]
     * @support  float $realMoney 待支付金额 [ require true ]
     * @support  array $productInfo 订单详情 [ require true ]
     * @support  array $retakeSkuIds 重拍的拍摄产品id [ require true ]
     * @support  string $reserveTime 预约时间 require false
     * @support  int $occupyNum 排单表占点数量 [ require true ]
     * @support  string $reason 重拍原因 [ require true ]
     * @support  array $reasonIds 重拍原因 [ require true ]
     * @support  string $note 备注 require false
     * @support  int $inputStaffId 录单人(非预约端需要当前操作伙伴id，日志展示使用) [ require true ]
     * @support  array $extend 订单extend require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取重拍的基础信息
     *
     * @support  int $orderId 原订单id require false
     * @support  int $retakeOrderId 重拍的订单id require false
     * @support  string $status 订单状态 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getBaseRetakeInfo () {
        return self::getClass()->getBaseRetakeInfo();
    }

    /**
     * 根据原订单ids，批量获取重拍的基础信息
     *
     * @support  array $orderIds 原订单id [ require true ]
     * @support  string $status 订单状态 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getBaseRetakeInfoListByOrderIds () {
        return self::getClass()->getBaseRetakeInfoListByOrderIds();
    }

    /**
     * 根据重拍的订单ids，批量获取重拍的基础信息
     *
     * @support  array $retakeOrderIds 重拍的订单id [ require true ]
     * @support  string $status 订单状态 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getBaseRetakeInfoListByRetakeOrderIds () {
        return self::getClass()->getBaseRetakeInfoListByRetakeOrderIds();
    }

    /**
     * 取消重拍订单
     *
     * @param  int $id 重拍的id [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @param  int $inputStaffId 录单人(非预约端需要当前操作伙伴id，日志展示使用) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $id, int $inputStaffId, string $reason = null) {
        return self::getClass()->cancel([
            "id" => $id,
            "inputStaffId" => $inputStaffId,
            "reason" => $reason,
        ]);
    }

    /**
     * 退款原因选项
     *
     * @param  string $category 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reasonOptions (string $category = null) {
        return self::getClass()->reasonOptions([
            "category" => $category,
        ]);
    }

    /**
     * 退款原因详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reasonDetail (int $id) {
        return self::getClass()->reasonDetail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderRetake');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderRetake');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}