<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method serviceCompleteByParams(array $params)
 * @method autoConfirmByParams(array $params)
 * @method listByParams(array $params)
 * @method removeByParams(array $params)
 * @method getOrderSaleSkusNameByParams(array $params)
 */
class OrderSaleSku {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 服务完成
     *
     * @param  int $id id [ require true ]
     * @param  array $ids ids [ require true ]
     * @param  bool $isUserComplete 是否是用户确认 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceComplete (int $id = NULL, array $ids = NULL, bool $isUserComplete = true) {
        return self::getClass()->serviceComplete([
            "id" => $id,
            "ids" => $ids,
            "isUserComplete" => $isUserComplete,
        ]);
    }

    /**
     * 标识拍摄产品是自动确认的，业务方放根据这个判断是否是自动完成，并做相关的操作
     *
     * @param  int $id id [ require true ]
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoConfirm (int $id = NULL, array $ids = NULL) {
        return self::getClass()->autoConfirm([
            "id" => $id,
            "ids" => $ids,
        ]);
    }

    /**
     * 页面——查账助手
     *
     * @support  int $storeId 门店ID 
     * @support  string $orderType 订单类型 
     * @support  string $type 子订单类型：order,ds 
     * @support  string $status 状态 
     * @support  array $statusList 状态列表 
     * @support  string $payType 支付类型，同子订单支付类型 
     * @support  string $paidAtStart 支付时间起始 [ require true ]
     * @support  string $paidAtEnd 支付时间结束 [ require true ]
     * @support  string $pageSize 条数 
     * @support  string $page 页码 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除拍摄产品
     *
     * @param  int $id 拍摄产品订单的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 获取拍摄产品的名称
     *
     * @param  array $ids 拍摄产品订单的ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderSaleSkusName (array $ids) {
        return self::getClass()->getOrderSaleSkusName([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderSaleSku');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderSaleSku');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}