<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method cancelByParams(array $params)
 * @method onTimeCloseNoPaidUpdateOrderByParams(array $params)
 * @method setPaidByParams(array $params)
 */
class OrderDiff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 如果修改订单已支付，返回的数据为空（该详情不是用于订单详情页面显示，用于未支付订单页面显示，获取重新开始修改订单）
     * 订单详情中的order_diff中的数据有type字段
     * 签到的未支付详情不是该接口，逻辑不同
     *
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $diffType 类型:upgrade和order [ require true ]
     * @param  bool $showCancel 是否显示取消的修改信息（会显示最新一个取消的修改信息） [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $orderDiffId, string $diffType, bool $showCancel = false) {
        return self::getClass()->detail([
            "orderDiffId" => $orderDiffId,
            "diffType" => $diffType,
            "showCancel" => $showCancel,
        ]);
    }

    /**
     * 取消未支付订单
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $reason 取消原因(取消修改和重新编辑) [ require true ]
     * @param  string $diffType 类型:upgrade和order [ require true ]
     * @param  int $inputStaffId 操作伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $orderId, int $orderDiffId, string $reason, string $diffType, int $inputStaffId) {
        return self::getClass()->cancel([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "reason" => $reason,
            "diffType" => $diffType,
            "inputStaffId" => $inputStaffId,
        ]);
    }

    /**
     * 自动关闭修改操作未支付的修改订单(定时任务)
     * 自动关闭修改操作产生的一小时未付款的订单
     * 该未支付订单的信息，不会将payment_info数据放到order中，类型是否重复使用，在生成修改订单时以判断
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function onTimeCloseNoPaidUpdateOrder () {
        return self::getClass()->onTimeCloseNoPaidUpdateOrder();
    }

    /**
     * 新增订单的设置签到不是该接口，在 OrderController 中的 setPaid
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $diffType 类型:upgrade和order [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @param  bool $fromPaymentGateway 来自支付网关 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setPaid (int $orderId, int $orderDiffId, string $diffType, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false) {
        return self::getClass()->setPaid([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "diffType" => $diffType,
            "payType" => $payType,
            "operateId" => $operateId,
            "paymentNo" => $paymentNo,
            "fromPaymentGateway" => $fromPaymentGateway,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderDiff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderDiff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}