<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method reasonOptionsByParams(array $params)
 * @method reasonDetailByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method getAllRefundListByOrderIdByParams(array $params)
 * @method getCanRefundPriceByItemIdsByParams(array $params)
 * @method createByParams(array $params)
 * @method fastRefundToGiftCardByParams(array $params)
 * @method passByParams(array $params)
 * @method modifyInfoByParams(array $params)
 * @method removeByParams(array $params)
 * @method confirmHandRefundByParams(array $params)
 * @method rejectByParams(array $params)
 * @method reapplyByParams(array $params)
 * @method fixRefundResultByParams(array $params)
 * @method getOrderRefundInfoByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款原因选项
     *
     * @param  string $category 分类：category_user_refund,category_admin_refund [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reasonOptions (string $category = '') {
        return self::getClass()->reasonOptions([
            "category" => $category,
        ]);
    }

    /**
     * 退款原因详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reasonDetail (int $id) {
        return self::getClass()->reasonDetail([
            "id" => $id,
        ]);
    }

    /**
     * 退款列表
     *
     * @support  int $orderId 主订单ID 
     * @support  string $status 状态 
     * @support  array $statusList 状态array 
     * @support  int $storeId 门店ID 
     * @support  array $storeIds 门店IDs 
     * @support  string $orderPayType 订单支付方式 
     * @support  string $applyTimeStart 申请时间-开始 
     * @support  string $applyTimeEnd 申请时间-结束 
     * @support  string $processTimeStart 处理时间-开始 
     * @support  string $processTimeEnd 处理时间-结束 
     * @support  string $completeTimeStart 退款完成-开始 
     * @support  string $completeTimeEnd 退款完成-结束 
     * @support  int $page  
     * @support  int $pageSize  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 退款详情
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取订单转退列表调用该接口
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  string $orderType 退款类型：order 订单 upgrade 升级服务 [ require true ]
     * @param  string $type 转退类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllRefundListByOrderId (int $orderId, string $orderType = NULL, string $type = 'all_refund') {
        return self::getClass()->getAllRefundListByOrderId([
            "orderId" => $orderId,
            "orderType" => $orderType,
            "type" => $type,
        ]);
    }

    /**
     * 获取部分子订单项可退金额及退款方式
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  array $refundInfo 待退款项 [ require true ]
     * @param  string $refundType 退款方式:full_refund 全部退款 part_refund 部分退款 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanRefundPriceByItemIds (int $orderId, array $refundInfo, string $refundType = 'part_refund') {
        return self::getClass()->getCanRefundPriceByItemIds([
            "orderId" => $orderId,
            "refundInfo" => $refundInfo,
            "refundType" => $refundType,
        ]);
    }

    /**
     * 创建退款
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $refundType 退款类型 [ require true ]
     * @support  int $scale 比例 [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  string $reason 原因 [ require true ]
     * @support  array $reasonIds 原因 
     * @support  string $note 备注 
     * @support  array $refundInfo 退款项(包含退款类型：order 订单 upgrade 升级服) [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @support  string $from 来源，用户预约端申请，后台申请 [ require true ]
     * @support  bool $isStaffPay 是否为伙伴垫付 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 快速退款至礼品卡
     * @deprecated
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $refundType 退款类型 [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $reason 原因 [ require true ]
     * @support  string $note 备注 
     * @support  array $refundInfo 退款项(包含退款类型：order 订单 upgrade 升级服) [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID [ require true ]
     * @support  bool $isStaffPay 是否为伙伴垫付 
     * @throws  \Exception
     * @return  array
     */
    public static function fastRefundToGiftCard () {
        return self::getClass()->fastRefundToGiftCard();
    }

    /**
     * 通过退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pass (int $id) {
        return self::getClass()->pass([
            "id" => $id,
        ]);
    }

    /**
     * 修改信息
     *
     * @param  int $id 退款ID [ require true ]
     * @param  int $operateId 操作伙伴 [ require true ]
     * @param  string $people 退款人 [ require true ]
     * @param  string $account 退款账户 [ require true ]
     * @param  array $extend 预约退款extend扩展信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyInfo (int $id, int $operateId, string $people = NULL, string $account = NULL, array $extend = NULL) {
        return self::getClass()->modifyInfo([
            "id" => $id,
            "operateId" => $operateId,
            "people" => $people,
            "account" => $account,
            "extend" => $extend,
        ]);
    }

    /**
     * 删除退款
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 手动退款再次确认
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function confirmHandRefund (int $id) {
        return self::getClass()->confirmHandRefund([
            "id" => $id,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $reason 退款原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reject (int $id, string $reason = '') {
        return self::getClass()->reject([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 重新申请退款
     *
     * @param  int $id 退款ID [ require true ]
     * @param  string $people 退款人 [ require true ]
     * @param  string $account 退款账户 [ require true ]
     * @param  string $reason 退款原因 [ require true ]
     * @param  int $inputStaffId 录入人伙伴ID [ require true ]
     * @param  int $scale 比例 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reapply (int $id, string $people, string $account, string $reason, int $inputStaffId, int $scale = 100) {
        return self::getClass()->reapply([
            "id" => $id,
            "people" => $people,
            "account" => $account,
            "reason" => $reason,
            "inputStaffId" => $inputStaffId,
            "scale" => $scale,
        ]);
    }

    /**
     * 修正退款结果
     *
     * @param  int $id 退款ID [ require true ]
     * @param  float $autoRealMoney 自动退款金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function fixRefundResult (int $id, float $autoRealMoney) {
        return self::getClass()->fixRefundResult([
            "id" => $id,
            "autoRealMoney" => $autoRealMoney,
        ]);
    }

    /**
     * 获取订单的退款相关信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderRefundInfo (int $orderId) {
        return self::getClass()->getOrderRefundInfo([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}