<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderSalesByParams(array $params)
 * @method createUpgradeSkuByParams(array $params)
 */
class OrderUpgrade {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单中的拍摄主产品
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderSales (int $id) {
        return self::getClass()->getOrderSales([
            "id" => $id,
        ]);
    }

    /**
     * 完成订单之后添加升级服务产品
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额 [Original type double] [ require true ]
     * @support  array $productInfo 订单详情 [ require true ]
     * @support  array $couponInfo 优惠券信息 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountType 特殊折扣类型 
     * @support  int $inputStaffId 伙伴ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createUpgradeSku () {
        return self::getClass()->createUpgradeSku();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderUpgrade');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderUpgrade');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}