<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotfixJxjyByParams(array $params)
 * @method hotfixCloseDianPingSkuByParams(array $params)
 * @method hotfixOrderServiceCompleteByParams(array $params)
 * @method hotfixOrderServiceCompleteByNpsByParams(array $params)
 * @method hotfixSetOrderPaidByParams(array $params)
 * @method batchLookPhotoByParams(array $params)
 * @method batchOrderServiceCompleteByParams(array $params)
 */
class HotfixOrderV4 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修复加修加印的接口
     *
     * @support  int $orderSaleSkuId 拍摄产品id 
     * @support  int $orderUpgradeSkuId 升级服务的id 
     * @support  int $jxjyPeopleNum 升级服务的人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixJxjy () {
        return self::getClass()->hotfixJxjy();
    }

    /**
     * 单独关闭点评的拍摄产品
     *
     * @param  int $orderId 拍摄产品id [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $orderSaleSkuId 拍摄产品id [ require true ]
     * @param  int $orderUpgradeSkuId 升级服务的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixCloseDianPingSku (int $orderId, string $reason, int $orderSaleSkuId = NULL, int $orderUpgradeSkuId = NULL) {
        return self::getClass()->hotfixCloseDianPingSku([
            "orderId" => $orderId,
            "reason" => $reason,
            "orderSaleSkuId" => $orderSaleSkuId,
            "orderUpgradeSkuId" => $orderUpgradeSkuId,
        ]);
    }

    /**
     * 修复订单完成服务
     *
     * @param  int $orderId 拍摄产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixOrderServiceComplete (int $orderId) {
        return self::getClass()->hotfixOrderServiceComplete([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 根据nps修复订单完成服务
     *
     * @param  int $orderId 拍摄产品id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixOrderServiceCompleteByNps (int $orderId = NULL, int $userId = NULL) {
        return self::getClass()->hotfixOrderServiceCompleteByNps([
            "orderId" => $orderId,
            "userId" => $userId,
        ]);
    }

    /**
     * 设置未支付的订单完成支付
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  bool $isFirstPaid 是否首次支付 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixSetOrderPaid (int $orderId, int $orderDiffId, string $payType, string $paymentNo, bool $isFirstPaid = true) {
        return self::getClass()->hotfixSetOrderPaid([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
            "isFirstPaid" => $isFirstPaid,
        ]);
    }

    /**
     * 批量修复完成看片信息
     *
     * @param  array $lookPhotoData 完成看片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchLookPhoto (array $lookPhotoData) {
        return self::getClass()->batchLookPhoto([
            "lookPhotoData" => $lookPhotoData,
        ]);
    }

    /**
     * 批量修复完成看片信息
     *
     * @param  array $orderInfo 完成服务的信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchOrderServiceComplete (array $orderInfo) {
        return self::getClass()->batchOrderServiceComplete([
            "orderInfo" => $orderInfo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'HotfixOrderV4');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'HotfixOrderV4');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}