<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderSalesByParams(array $params)
 * @method createUpgradeSkuByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method setLookPhotoCompleteByParams(array $params)
 * @method clearLookPhotoCompletedAtByParams(array $params)
 * @method getUpgradeSkuListByParams(array $params)
 */
class OrderUpgrade {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单中的拍摄主产品
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderSales (int $id) {
        return self::getClass()->getOrderSales([
            "id" => $id,
        ]);
    }

    /**
     * 完成订单之后添加升级服务产品
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额 [Original type double] [ require true ]
     * @support  array $productInfo 订单详情 [ require true ]
     * @support  array $couponInfo 优惠券信息 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountType 特殊折扣类型 
     * @support  int $inputStaffId 伙伴ID [ require true ]
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id 
     * @throws  \Exception
     * @return  array
     */
    public static function createUpgradeSku () {
        return self::getClass()->createUpgradeSku();
    }

    /**
     * 服务完成
     *
     * @param  int $id id [ require true ]
     * @param  array $ids ids [ require true ]
     * @param  bool $isUserComplete 是否是用户确认 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceComplete (int $id = NULL, array $ids = NULL, bool $isUserComplete = true) {
        return self::getClass()->serviceComplete([
            "id" => $id,
            "ids" => $ids,
            "isUserComplete" => $isUserComplete,
        ]);
    }

    /**
     * 标识拍摄产品是自动确认的，业务方放根据这个判断是否是自动完成，并做相关的操作
     *
     * @param  int $id id [ require true ]
     * @param  array $ids ids [ require true ]
     * @param  string $type 完成看片类型:auto,user [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setLookPhotoComplete (int $id = NULL, array $ids = NULL, string $type = 'user') {
        return self::getClass()->setLookPhotoComplete([
            "id" => $id,
            "ids" => $ids,
            "type" => $type,
        ]);
    }

    /**
     * 只清除自动看片的标识，可以再次看片
     *
     * @param  int $id 订单id [ require true ]
     * @param  array $ids ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearLookPhotoCompletedAt (int $id = NULL, array $ids = NULL) {
        return self::getClass()->clearLookPhotoCompletedAt([
            "id" => $id,
            "ids" => $ids,
        ]);
    }

    /**
     * 获取预约看片信息
     *
     * @support  int $storeId 门店id [Original type uint] 
     * @support  int $orderId 订单id [Original type uint] 
     * @support  array $storeIds 门店ids 
     * @support  array $orderIds 订单ids 
     * @support  string $createTimeStart 查询开始时间 
     * @support  string $createTimeEnd 查询结束时间 
     * @support  string $status 订单状态 
     * @support  array $statusList 订单状态 
     * @support  bool $hasServiceCompleteAt 是否需要看片完成服务时间 
     * @throws  \Exception
     * @return  array
     */
    public static function getUpgradeSkuList () {
        return self::getClass()->getUpgradeSkuList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderUpgrade');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderUpgrade');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}