<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method changePayTypeByParams(array $params)
 */
class Turnover {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单的流水
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $orderType 订单类型：order 订单相关流水，upgrade 升级服务相关流水 [ require true ]
     * @param  string $turnoverType 流水的类型：，income 收入，disburse 支出 [ require true ]
     * @param  string $sortField 排序字段 [ require true ]
     * @param  bool $sortDesc 是否倒序 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $orderId, string $orderType, int $page = 1, int $pageSize = 10, string $turnoverType = '', string $sortField = 'id', bool $sortDesc = false) {
        return self::getClass()->list([
            "orderId" => $orderId,
            "orderType" => $orderType,
            "page" => $page,
            "pageSize" => $pageSize,
            "turnoverType" => $turnoverType,
            "sortField" => $sortField,
            "sortDesc" => $sortDesc,
        ]);
    }

    /**
     * 修改支付方式
     *
     * @param  int $id 流水的id [ require true ]
     * @param  string $orderType 订单类型：order 订单相关流水，upgrade 升级服务相关流水 [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePayType (int $id, string $orderType, string $payType, string $paymentNo = '', int $operateId = 0) {
        return self::getClass()->changePayType([
            "id" => $id,
            "orderType" => $orderType,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
            "operateId" => $operateId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Turnover');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Turnover');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}