<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hotfixJxjyByParams(array $params)
 * @method hotfixCloseDianPingSkuByParams(array $params)
 * @method getOrderInfoByParams(array $params)
 */
class HotfixOrderV4 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修复加修加印的接口
     *
     * @support  int $orderSaleSkuId 拍摄产品id 
     * @support  int $orderUpgradeSkuId 升级服务的id 
     * @support  int $jxjyPeopleNum 升级服务的人数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixJxjy () {
        return self::getClass()->hotfixJxjy();
    }

    /**
     * 单独关闭点评的拍摄产品
     *
     * @param  int $orderId 拍摄产品id [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $orderSaleSkuId 拍摄产品id [ require true ]
     * @param  int $orderUpgradeSkuId 升级服务的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hotfixCloseDianPingSku (int $orderId, string $reason, int $orderSaleSkuId = NULL, int $orderUpgradeSkuId = NULL) {
        return self::getClass()->hotfixCloseDianPingSku([
            "orderId" => $orderId,
            "reason" => $reason,
            "orderSaleSkuId" => $orderSaleSkuId,
            "orderUpgradeSkuId" => $orderUpgradeSkuId,
        ]);
    }

    /**
     * 根据订单标号获取老订单的信息
     *
     * @param  string $orderNo 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderInfo (string $orderNo) {
        return self::getClass()->getOrderInfo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'HotfixOrderV4');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'HotfixOrderV4');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}