<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getStaffNpsListByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getByOrderIdByParams(array $params)
 * @method getNoneNpsOrdersByParams(array $params)
 * @method batchCheckOrderHasNpsByParams(array $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * NPS列表
     *
     * @support  int $storeId 门店ID 
     * @support  array $orderIds 订单IDs 
     * @support  int $score 评分范围 
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  bool $isSn 是否查询sn 
     * @support  bool $isNeedStat 是否NeedStat 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 查询伙伴的NPS列表
     *
     * @support  int $staffId 伙伴ID 
     * @support  int $storeId 门店ID 
     * @support  array $orderIds 订单IDs 
     * @support  string $job 职位 
     * @support  int $score 评分范围 
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  bool $isSn 是否查询sn 
     * @support  bool $isNeedStat 是否NeedStat 
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffNpsList () {
        return self::getClass()->getStaffNpsList();
    }

    /**
     * 创建NPS
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $userId 用户uid [ require true ]
     * @support  int $all 总评分 [ require true ]
     * @support  int $receptionist 门市客服评分 [ require true ]
     * @support  int $cameraman 摄影师平分 [ require true ]
     * @support  int $dresser 化妆师评分 [ require true ]
     * @support  int $retoucher 看片师评分 [ require true ]
     * @support  string $note 其他反馈 
     * @support  int $isSn 是否参与sn 
     * @support  int $isShare 是否参与分享 
     * @support  int $isStat 是否参与统计 
     * @support  array $extend extend 
     * @support  int $retoucherCommunication 看片师沟通体验/app 
     * @support  int $retoucherResponse 看片师响应速度/app 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新NPS
     *
     * @param  int $id ID [ require true ]
     * @param  int $all 总评分 [ require true ]
     * @param  int $receptionist 门市客服评分 [ require true ]
     * @param  int $cameraman 摄影师平分 [ require true ]
     * @param  int $dresser 化妆师评分 [ require true ]
     * @param  int $retoucher 看片师评分 [ require true ]
     * @param  int $isStat 是否参与统计 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, int $all = 0, int $receptionist = 0, int $cameraman = 0, int $dresser = 0, int $retoucher = 0, int $isStat = 1) {
        return self::getClass()->update([
            "id" => $id,
            "all" => $all,
            "receptionist" => $receptionist,
            "cameraman" => $cameraman,
            "dresser" => $dresser,
            "retoucher" => $retoucher,
            "isStat" => $isStat,
        ]);
    }

    /**
     * 更加订单ID获取NPS信息
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getByOrderId (int $orderId) {
        return self::getClass()->getByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * fixme 有修改
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoneNpsOrders () {
        return self::getClass()->getNoneNpsOrders();
    }

    /**
     * 只返回评价过NPS的订单ID数组
     *
     * @param  array $order_ids 订单ID数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCheckOrderHasNps (array $order_ids) {
        return self::getClass()->batchCheckOrderHasNps([
            "order_ids" => $order_ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}