<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method setOrderNameByParams(array $params)
 * @method detailByParams(array $params)
 * @method cancelByParams(array $params)
 * @method onTimeCloseOrderByParams(array $params)
 * @method searchUseDbByParams(array $params)
 * @method searchUseEsByParams(array $params)
 * @method getStoreWaitSignNumByParams(array $params)
 * @method removeByParams(array $params)
 * @method deleteByUserByParams(array $params)
 * @method closeByParams(array $params)
 * @method closeMeiTuanOrderByParams(array $params)
 * @method closeMantuOrderByParams(array $params)
 * @method useGiftCardMoneyByParams(array $params)
 * @method giftCardPrePayByParams(array $params)
 * @method useMarketCardMoneyByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method mantuOrderFirstPayByParams(array $params)
 * @method mantuOrderFinalPayByParams(array $params)
 * @method startByParams(array $params)
 * @method finishPaperlessByParams(array $params)
 * @method finishByParams(array $params)
 * @method finishMantuOrderByParams(array $params)
 * @method completeLookPhotoByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method clearConfirmationByParams(array $params)
 * @method getConfirmationByIdsByParams(array $params)
 * @method changeLookPhotoReserveTimeByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method recoverFinishedToWaitShootingByParams(array $params)
 * @method getOrderStatusByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 * @method getOrderConsumeMoneyByParams(array $params)
 * @method getOrderOperateLogByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method queryDsListWithStoreByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method getProductsInOrdersByParams(array $params)
 * @method changeExtendByParams(array $params)
 * @method userReachedByParams(array $params)
 * @method getUserReachedDetailByParams(array $params)
 * @method modifyUserReachedByParams(array $params)
 * @method cancelUserReachedByParams(array $params)
 * @method setUserReachedPaidByParams(array $params)
 * @method getStoreFinishOrderCountByParams(array $params)
 * @method setOrderPaperlessFinishByParams(array $params)
 * @method getInvoiceListByParams(array $params)
 * @method getStoreOrderCountByParams(array $params)
 * @method getOrderUnSetServiceCompleteByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 可以添加两个相同的产品（升级服务或者加修加印不一定是一样的）,以addNumber区分
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $userId 用户ID 
     * @support  int $orderUserId 订单用户ID 
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户性别 
     * @support  string $userBirthday 用户生日 
     * @support  string $userEmail 用户邮箱 
     * @support  string $from 订单来源 [ require true ]
     * @support  int $peopleNum 订单到店人数（商品的最大人数） 
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额（钱） [Original type double] [ require true ]
     * @support  array $productInfo 订单详情 [ require true ]
     * @support  array $reachedInfo 到店签到信息（门店端使用） 
     * @support  array $globalDiscountIds 全局优惠ID（产品的组合优惠） 
     * @support  float $globalDiscountMoney 全局优惠金额 [Original type double] 
     * @support  array $packageDiscountIds 套餐优惠信息 
     * @support  float $packageDiscountMoney 套餐优惠金额 [Original type double] 
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  array $couponInfo 优惠券信息 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  float $peopleDiscountMoney 人数优惠（加购优惠） [Original type double] 
     * @support  string $discountType 特殊折扣类型 
     * @support  float $giftCardPayMoney 礼品卡金额 [Original type double] 
     * @support  float $marketCardMoney 商场卡金额 [Original type double] 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $occupyNum 派单表占点数量 [ require true ]
     * @support  string $module 订单模块 [ require true ]
     * @support  string $type 订单类型 [ require true ]
     * @support  int $inputStaffId 录单人(非预约端需要当前操作伙伴id，日志展示使用) 
     * @support  array $extend 订单extend 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 自动设置订单编号(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderName () {
        return self::getClass()->setOrderName();
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $orderNo 订单编号 [ require true ]
     * @param  bool $withDelete 是否包含删除的订单 [ require true ]
     * @param  bool $withRefund 是否包含已经关闭的订单 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id = NULL, string $orderNo = NULL, bool $withDelete = false, bool $withRefund = false) {
        return self::getClass()->detail([
            "id" => $id,
            "orderNo" => $orderNo,
            "withDelete" => $withDelete,
            "withRefund" => $withRefund,
        ]);
    }

    /**
     * 一个订单不可以同时调用不同的可以修改订单状态的操作
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 自动关闭一个小时之外的订单(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function onTimeCloseOrder () {
        return self::getClass()->onTimeCloseOrder();
    }

    /**
     * 使用数据库查询订单
     *
     * @support  array $orderIds 订单ids 
     * @support  array $notInOrderIds 订单ids 
     * @support  array $orderNos 订单编号s 
     * @support  array $storeIds 门店ids 
     * @support  string $reserveTimeStart 预约开始时间 
     * @support  string $reserveTimeEnd 预约结束时间 
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 
     * @support  string $createTimeStart 查询开始时间 
     * @support  string $createTimeEnd 查询结束时间 
     * @support  string $lookPhotoTimeStart 看片完成开始时间 
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 
     * @support  array $userIds 绑定用户uids 
     * @support  string $status 订单状态 
     * @support  array $statusList 订单状态 
     * @support  bool $hasLookPhotoCompleteAt 是否需要看片完成时间 
     * @support  string $userName 下单用户 
     * @support  string $module 模块 
     * @support  string $type 订单类型 
     * @support  string $userPhone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  string $sortField 排序字段 
     * @support  bool $sortDesc 是否倒序 
     * @support  bool $withDel 是否需要删除数据 
     * @support  bool $withRefund 是否包含已经关闭的订单 
     * @support  array $customerCareTypes 售后的类型,beforeRetakeOrder :重拍前订单 ,afterRetakeOrder : 重拍后订单 
     * @throws  \Exception
     * @return  array
     */
    public static function searchUseDb () {
        return self::getClass()->searchUseDb();
    }

    /**
     * 使用ES查询订单
     *
     * @support  array $orderIds 订单ids 
     * @support  array $orderNos 订单编号s 
     * @support  array $storeIds 门店ids 
     * @support  string $reserveTimeStart 预约开始时间 
     * @support  string $reserveTimeEnd 预约结束时间 
     * @support  string $lookPhotoReserveTimeStart 看片预约开始时间 
     * @support  string $lookPhotoReserveTimeEnd 看片预约结束时间 
     * @support  string $createTimeStart 查询开始时间 
     * @support  string $createTimeEnd 查询结束时间 
     * @support  string $lookPhotoTimeStart 看片完成开始时间 
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 
     * @support  array $userIds 绑定用户uids 
     * @support  string $status 订单状态 
     * @support  array $statusList 订单状态 
     * @support  bool $hasLookPhotoCompleteAt 是否需要看片完成时间 
     * @support  string $userName 下单用户 
     * @support  string $module 模块 
     * @support  string $type 订单类型 
     * @support  string $userPhone 手机号 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  string $sortField 排序字段 
     * @support  bool $sortDesc 是否倒序 
     * @support  bool $withDel 是否需要删除数据 
     * @support  bool $withRefund 是否包含已经关闭的订单 
     * @support  array $customerCareTypes 售后的类型,beforeRetakeOrder :重拍前订单 ,afterRetakeOrder : 重拍后订单 
     * @throws  \Exception
     * @return  array
     */
    public static function searchUseEs () {
        return self::getClass()->searchUseEs();
    }

    /**
     * 获取门店等待签到的数据
     *
     * @param  int $storeId 门店id [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getStoreWaitSignNum (int $storeId, string $reserveTime = NULL) {
        return self::getClass()->getStoreWaitSignNum([
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
        ]);
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 用户删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 操作删除的id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteByUser (int $id, int $operateId) {
        return self::getClass()->deleteByUser([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 当订单内有已经退款处理中的拍摄产品订单，均不符合关闭订单条件，禁止关单。
     * 1、美团店点评不能关
     * 2、包含有网关支付的不能惯
     * 该接口会清空工作量、取消排单表
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason, int $operateId) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 关闭美团订单
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMeiTuanOrder (int $id) {
        return self::getClass()->closeMeiTuanOrder([
            "id" => $id,
        ]);
    }

    /**
     * 该接口会清空工作量、取消排单表
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMantuOrder (int $id, string $reason = '', int $operateId = 0) {
        return self::getClass()->closeMantuOrder([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 已提交的子订单在正式支付前，使用礼品卡金额抵扣一部分实付金额
     * 调用该接口会重新设置子订单的实付金额和礼品卡支付金额
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardPayMoney 礼品卡金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useGiftCardMoney (int $id, float $giftCardPayMoney) {
        return self::getClass()->useGiftCardMoney([
            "id" => $id,
            "giftCardPayMoney" => $giftCardPayMoney,
        ]);
    }

    /**
     * 本接口对已经提交了，但是处于待支付状态的订单，进行礼品卡预支付
     * 本接口适应场景：当管理端开单，订单已经提交，即将进行下一步支付的时候，可以修改支付金额，选择全部或者部分金额使用礼品卡支付。
     * 签到不可以使用礼品卡
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function giftCardPrePay (int $id) {
        return self::getClass()->giftCardPrePay([
            "id" => $id,
        ]);
    }

    /**
     * 签到不可以使用礼品卡
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $marketCardMoney 商场卡金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useMarketCardMoney (int $id, float $marketCardMoney) {
        return self::getClass()->useMarketCardMoney([
            "id" => $id,
            "marketCardMoney" => $marketCardMoney,
        ]);
    }

    /**
     * 设置订单完成支付——新建订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @param  bool $fromPaymentGateway 来自支付网关 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, int $orderDiffId, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false) {
        return self::getClass()->setPaid([
            "id" => $id,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "operateId" => $operateId,
            "paymentNo" => $paymentNo,
            "fromPaymentGateway" => $fromPaymentGateway,
        ]);
    }

    /**
     * 缦图订单付首款
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $payMode 全款还是部分付款，part_payment，full_payment [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  bool $fromPaymentGateway 来自支付网关 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuOrderFirstPay (int $id, int $orderDiffId, string $payType, string $payMode, string $paymentNo = '', bool $fromPaymentGateway = false) {
        return self::getClass()->mantuOrderFirstPay([
            "id" => $id,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "payMode" => $payMode,
            "paymentNo" => $paymentNo,
            "fromPaymentGateway" => $fromPaymentGateway,
        ]);
    }

    /**
     * 缦图订单付尾款
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  float $money 尾款金额 [Original type double] [ require true ]
     * @param  string $paymentNo 支付流水号，非必填 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuOrderFinalPay (int $id, int $orderDiffId, string $payType, float $money, string $paymentNo = '') {
        return self::getClass()->mantuOrderFinalPay([
            "id" => $id,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "money" => $money,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id, int $operateId) {
        return self::getClass()->start([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 摄影师将订单中的拍摄产品全部操作上传看片
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishPaperless (int $id) {
        return self::getClass()->finishPaperless([
            "id" => $id,
        ]);
    }

    /**
     * 门店完成订单——录入工作量
     *
     * @param  int $id 订单ID [ require true ]
     * @param  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finish (int $id, array $workloads, int $operateId) {
        return self::getClass()->finish([
            "id" => $id,
            "workloads" => $workloads,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 完成缦图订单
     *
     * @param  int $id 订单id [ require true ]
     * @param  int $operateId 录单人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishMantuOrder (int $id, int $operateId) {
        return self::getClass()->finishMantuOrder([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * （同时需要录入工作量,自动完成看片也调用该接口）
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $staffId 伙伴ID [ require true ]
     * @param  int $workPer 工作量占比 [ require true ]
     * @param  string $type 完成看片类型:auto,user [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeLookPhoto (int $id, int $staffId = 0, int $workPer = 0, string $type = 'user') {
        return self::getClass()->completeLookPhoto([
            "id" => $id,
            "staffId" => $staffId,
            "workPer" => $workPer,
            "type" => $type,
        ]);
    }

    /**
     * 服务整体完成（用户确认服务完成）
     *
     * @param  int $id id [ require true ]
     * @param  string $type 完成类型:auto,user [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceComplete (int $id, string $type) {
        return self::getClass()->serviceComplete([
            "id" => $id,
            "type" => $type,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  string $note 备注（如果填则记录） [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @param  int $occupyNum 占点数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime (int $id, string $reserveTime, int $operateId, string $note = '', int $occupyNum = 0) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserveTime" => $reserveTime,
            "operateId" => $operateId,
            "note" => $note,
            "occupyNum" => $occupyNum,
        ]);
    }

    /**
     * 只清除自动看片的标识，可以再次看片
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearConfirmation (int $id) {
        return self::getClass()->clearConfirmation([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单id查询自动看片完成信息
     *
     * @param  array $ids 订单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getConfirmationByIds (array $ids) {
        return self::getClass()->getConfirmationByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 改变订单的看片预约时间
     *
     * @param  int $id 订单id [ require true ]
     * @param  string $lookPhotoReserveTime 看片预约时间 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeLookPhotoReserveTime (int $id, int $operateId, string $lookPhotoReserveTime = NULL) {
        return self::getClass()->changeLookPhotoReserveTime([
            "id" => $id,
            "operateId" => $operateId,
            "lookPhotoReserveTime" => $lookPhotoReserveTime,
        ]);
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id, int $operateId) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 把完成的订单恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverFinishedToWaitShooting (int $id, int $operateId) {
        return self::getClass()->recoverFinishedToWaitShooting([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 获取门店下订单不同状态数量【专供缦图订单接口】
     *
     * @param  int $storeId 门店iD [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  bool $needToday 是否仅需要当天数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderStatus (int $storeId, string $module, bool $needToday = false) {
        return self::getClass()->getOrderStatus([
            "storeId" => $storeId,
            "module" => $module,
            "needToday" => $needToday,
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $orderNo) {
        return self::getClass()->getIdByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @param  string $userPhone 用户手机号 [ require true ]
     * @param  bool $force 强制绑定 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $userId, string $userPhone, bool $force = false, int $operateId = 0) {
        return self::getClass()->bindUser([
            "id" => $id,
            "userId" => $userId,
            "userPhone" => $userPhone,
            "force" => $force,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 解绑用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id, int $operateId) {
        return self::getClass()->unbindUser([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 批量更新订单的发票ID
     *
     * @param  int $invoiceId 发票ID [ require true ]
     * @param  array $orderNos 订单号数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (int $invoiceId, array $orderNos) {
        return self::getClass()->batchUpdateInvoiceId([
            "invoiceId" => $invoiceId,
            "orderNos" => $orderNos,
        ]);
    }

    /**
     * 计算订单消费金额
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getOrderConsumeMoney (int $id) {
        return self::getClass()->getOrderConsumeMoney([
            "id" => $id,
        ]);
    }

    /**
     * 查看订单操作日志
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOperateLog (int $orderId) {
        return self::getClass()->getOrderOperateLog([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $userName 用户姓名 [ require true ]
     * @param  string $userSex 用户性别 [ require true ]
     * @param  string $userEmail 用户邮箱 [ require true ]
     * @param  string $userBirthday 用户生日 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeUserData (int $id, string $userName = NULL, string $userSex = NULL, string $userEmail = NULL, string $userBirthday = NULL, int $operateId = 0) {
        return self::getClass()->changeUserData([
            "id" => $id,
            "userName" => $userName,
            "userSex" => $userSex,
            "userEmail" => $userEmail,
            "userBirthday" => $userBirthday,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 转门店只有没有二销的才可以，只会转一销
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $storeId 门店ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  int $occupyNum 占点数 [Original type uint] [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeStore (int $id, int $storeId, string $reserveTime, int $operateId, int $occupyNum = 0) {
        return self::getClass()->changeStore([
            "id" => $id,
            "storeId" => $storeId,
            "reserveTime" => $reserveTime,
            "operateId" => $operateId,
            "occupyNum" => $occupyNum,
        ]);
    }

    /**
     * 【缦图使用】
     *
     * @param  int $dsModel 查询类型 1：共享 2：主推 [ require true ]
     * @param  int $staffId 伙伴id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @param  bool $withUpgrade 包含升级服务 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @param  string $startTime 开始时间 [ require true ]
     * @param  string $endTime 结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryDsListWithStore (int $staffId, string $startTime, string $endTime, int $dsModel = 2, int $storeId = 0, bool $withUpgrade = true, int $page = 1, int $pageSize = 10) {
        return self::getClass()->queryDsListWithStore([
            "staffId" => $staffId,
            "startTime" => $startTime,
            "endTime" => $endTime,
            "dsModel" => $dsModel,
            "storeId" => $storeId,
            "withUpgrade" => $withUpgrade,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取订单中的拍摄产品，过滤不用上传到云端的产品
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $orderSaleId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrder (string $orderNo = '', int $orderId = 0, int $orderSaleId = NULL) {
        return self::getClass()->getProductsInOrder([
            "orderNo" => $orderNo,
            "orderId" => $orderId,
            "orderSaleId" => $orderSaleId,
        ]);
    }

    /**
     * 获取订单中的拍摄产品，过滤不用上传到云端的产品
     *
     * @param  array $orderNos 订单号数组 [ require true ]
     * @param  array $orderIds 订单ID数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrders (array $orderNos = [], array $orderIds = []) {
        return self::getClass()->getProductsInOrders([
            "orderNos" => $orderNos,
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 到店人数在签到接口
     *
     * @support  int $id 订单ID 
     * @support  string $note 订单备注 
     * @support  string $noPaperNote 无纸化备注 
     * @support  int $modifyCount 修改次数 
     * @support  int $operateId 录单人 [ require true ]
     * @support  string $partRefundTime 部分退款时间 
     * @support  string $appointLookPhotoSource 预约看片来源 user 用户预约端 store 门店端 
     * @support  string $outsideCity 外拍订单城市 
     * @support  string $outsideAddress 外拍订单地址 
     * @support  string $groupName 无纸化分组名称 
     * @support  int $groupId 无纸化分组id 
     * @support  string $paperlessNote 无纸化备注 
     * @support  string $firstWatchFinishType 第一次订单看片完成类型 
     * @support  array $sendMemberCoupons 发送会员优惠券 
     * @support  array $birthGiftInfo 生日礼遇领取信息 
     * @throws  \Exception
     * @return  array
     */
    public static function changeExtend () {
        return self::getClass()->changeExtend();
    }

    /**
     * 设置拍摄订单签到
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $reachedPeopleNum 签到人数 [Original type uint] [ require true ]
     * @param  int $inputStaffId 伙伴ID [ require true ]
     * @param  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @param  float $money 签到补收金额（如果不需要补收，可以为空） [Original type double] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function userReached (int $orderId, int $reachedPeopleNum, int $inputStaffId, bool $needMoney, float $money = 0.0) {
        return self::getClass()->userReached([
            "orderId" => $orderId,
            "reachedPeopleNum" => $reachedPeopleNum,
            "inputStaffId" => $inputStaffId,
            "needMoney" => $needMoney,
            "money" => $money,
        ]);
    }

    /**
     * 如果没有数据，说明没有支付信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserReachedDetail (int $orderId) {
        return self::getClass()->getUserReachedDetail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 修改拍摄订单签到
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $reachedPeopleNum 签到人数 [Original type uint] [ require true ]
     * @param  int $inputStaffId 伙伴ID [ require true ]
     * @param  bool $needMoney 是否需要补收金额(不需要补收金额，会直接设置完成，不用在执行签到完成支付) [ require true ]
     * @param  float $money 签到补收金额（如果不需要补收，可以为空），减去原先已经支付的签到金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyUserReached (int $orderId, int $reachedPeopleNum, int $inputStaffId, bool $needMoney, float $money = 0.0) {
        return self::getClass()->modifyUserReached([
            "orderId" => $orderId,
            "reachedPeopleNum" => $reachedPeopleNum,
            "inputStaffId" => $inputStaffId,
            "needMoney" => $needMoney,
            "money" => $money,
        ]);
    }

    /**
     * 只能操作未支付的拍摄签到订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @param  int $inputStaffId 伙伴ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelUserReached (int $orderId, int $orderDiffId, int $inputStaffId, string $reason) {
        return self::getClass()->cancelUserReached([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "inputStaffId" => $inputStaffId,
            "reason" => $reason,
        ]);
    }

    /**
     * 如果不需要补收金额，不用调该接口
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $orderDiffId order_diff的id [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @param  bool $fromPaymentGateway 来自支付网关 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setUserReachedPaid (int $orderId, int $orderDiffId, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false) {
        return self::getClass()->setUserReachedPaid([
            "orderId" => $orderId,
            "orderDiffId" => $orderDiffId,
            "payType" => $payType,
            "operateId" => $operateId,
            "paymentNo" => $paymentNo,
            "fromPaymentGateway" => $fromPaymentGateway,
        ]);
    }

    /**
     * 获取门店订单完成数量
     *
     * @param  string $startDate 查询开始时间 [ require true ]
     * @param  string $endDate 查询结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreFinishOrderCount (string $startDate, string $endDate) {
        return self::getClass()->getStoreFinishOrderCount([
            "startDate" => $startDate,
            "endDate" => $endDate,
        ]);
    }

    /**
     * 设置订单的无纸化完成
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setOrderPaperlessFinish (int $id) {
        return self::getClass()->setOrderPaperlessFinish([
            "id" => $id,
        ]);
    }

    /**
     * 获取订单可开发票信息接口
     *
     * @support  int $storeId 门店id 
     * @support  int $userId 用户id [Original type uint] 
     * @support  int $orderId 订单id [Original type uint] 
     * @support  array $orderIds 订单ids 
     * @support  string $sortField 排序字段 
     * @support  bool $sortDesc 是否倒序 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function getInvoiceList () {
        return self::getClass()->getInvoiceList();
    }

    /**
     * 获取上个月门店订单完成数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreOrderCount () {
        return self::getClass()->getStoreOrderCount();
    }

    /**
     * 根据看片时间获取未设置完成服务的拍摄产品
     *
     * @support  string $lookPhotoTimeStart 看片完成开始时间 
     * @support  string $lookPhotoTimeEnd 看片完成结束时间 
     * @support  string $orderType 订单类型: order: 订单 upgrade:升级服务 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  string $sortField 排序字段 
     * @support  bool $sortDesc 是否倒序 
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderUnSetServiceComplete () {
        return self::getClass()->getOrderUnSetServiceComplete();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}