<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method modifyOrderByParams(array $params)
 */
class OrderUpdate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 原订单的实付金额= real_money + gift_card_money + market_money
     * 如果原先有优惠信息，未修改的情况下，需要将原先的优惠信息也传递过来
     * 现在只有门店端可以操作，预约端不可操作，所以没有新的礼品卡支付金额和商场卡支付金额
     * money 为整个订单的金额，realMoney 未整个订单需要支付的金额
     * needPaidMoney： 剩余待支付金额（realMoney-原订单实付金额（不含已退款或者转退的金额））
     * 原订单实付金额 = real_money + gift_card_money + market_money
     *
     * @support  int $id 订单id [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额 [Original type double] [ require true ]
     * @support  float $needPaidMoney 待支付的金额 [Original type double] [ require true ]
     * @support  int $peopleNum 订单到店人数（商品的最大人数） 
     * @support  array $productInfo 订单详情（如果是原先存在，需要有id） [ require true ]
     * @support  array $reachedInfo 到店签到信息（门店端使用） [ require true ]
     * @support  array $globalDiscountIds 全局优惠ID（产品的组合优惠） 
     * @support  float $globalDiscountMoney 全局优惠金额 [Original type double] 
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  array $couponInfo 优惠券信息 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountType 特殊折扣类型 
     * @support  int $operateId 录单人(非预约端需要当前操作伙伴id，日志展示使用) [ require true ]
     * @support  int $specialDiscountStaffId 特殊折扣使用的伙伴id 
     * @throws  \Exception
     * @return  array
     */
    public static function modifyOrder () {
        return self::getClass()->modifyOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderUpdate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderUpdate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}