<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBatchSubOrderItemByParams(array $params)
 * @method updateByParams(array $params)
 */
class SubOrderDetailItem {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据id批量获取subOrderItem
     *
     * @param  array $ids item id数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBatchSubOrderItem (array $ids) {
        return self::getClass()->getBatchSubOrderItem([
            "ids" => $ids,
        ]);
    }

    /**
     * 更新subOrderItem数据
     *
     * @param  int $id item id [ require true ]
     * @support  string $user_sex user_sex 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'SubOrderDetailItem');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'SubOrderDetailItem');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}