<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderPaidByParams(array $params)
 * @method orderCancelByParams(array $params)
 * @method orderRefundByParams(array $params)
 */
class Sensors {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单确认支付
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $subOrderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderPaid (int $orderId, int $subOrderId, int $storeId) {
        return self::getClass()->orderPaid([
            "orderId" => $orderId,
            "subOrderId" => $subOrderId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 订单取消
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $subOrderId 订单id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderCancel (int $orderId, int $subOrderId, int $storeId) {
        return self::getClass()->orderCancel([
            "orderId" => $orderId,
            "subOrderId" => $subOrderId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * 订单退款
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $refundId 退款id [ require true ]
     * @param  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderRefund (int $orderId, int $refundId, int $storeId) {
        return self::getClass()->orderRefund([
            "orderId" => $orderId,
            "refundId" => $refundId,
            "storeId" => $storeId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Sensors');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Sensors');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}