<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchUseDbByParams(array $params)
 * @method searchUseEsByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByOrderNoByParams(array $params)
 * @method createByParams(array $params)
 * @method submitByParams(array $params)
 * @method createAndSubmitByParams(array $params)
 * @method removeByParams(array $params)
 * @method cancelByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method startByParams(array $params)
 * @method closeByParams(array $params)
 * @method closeMeiTuanOrderByParams(array $params)
 * @method closeMantuOrderByParams(array $params)
 * @method finishByParams(array $params)
 * @method finishMantuOrderByParams(array $params)
 * @method completeLookPhotoByParams(array $params)
 * @method serviceCompleteByParams(array $params)
 * @method sysServiceCompleteByParams(array $params)
 * @method changeReserveTimeWhenNoSubmitByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method changeExtendByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method recoverFinishedToWaitShootingByParams(array $params)
 * @method getIdByNoByParams(array $params)
 * @method getNoByIdByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method deleteByUserByParams(array $params)
 * @method getProductsInOrderByParams(array $params)
 * @method getProductsInOrdersByParams(array $params)
 * @method getProductsInfoInOrdersByParams(array $params)
 * @method batchUpdateInvoiceIdByParams(array $params)
 * @method mantuOrderFirstPayByParams(array $params)
 * @method mantuOrderFinalPayByParams(array $params)
 * @method onTimeCloseOrderByParams(array $params)
 * @method getOrderConsumeMoneyByParams(array $params)
 * @method getOrderStatusByParams(array $params)
 * @method queryDsListWithStoreByParams(array $params)
 * @method getOrderOperateLogByParams(array $params)
 * @method autoConfirmByParams(array $params)
 * @method clearConfirmationByParams(array $params)
 * @method getConfirmationByIdsByParams(array $params)
 * @method changeLookPhotoReserveTimeByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 使用数据库查询订单
     *
     * @support  array $order_ids 订单编号s 
     * @support  array $order_nos 订单ids 
     * @support  array $store_ids 门店ids 
     * @support  array $product_ids 产品ids 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  string $look_photo_reserve_time_start 看片预约开始时间 
     * @support  string $look_photo_reserve_time_end 看片预约结束时间 
     * @support  string $create_time_start 查询开始时间 
     * @support  string $create_time_end 查询结束时间 
     * @support  string $look_photo_time_start 看片完成开始时间 
     * @support  string $look_photo_time_end 看片完成结束时间 
     * @support  array $user_ids 绑定用户uids 
     * @support  string $status 订单状态 
     * @support  array $status_list 订单状态 
     * @support  string $pending_status 无纸化状态 
     * @support  array $pending_status_list 无纸化状态数组 
     * @support  string $user_name 下单用户 
     * @support  string $module 模块 
     * @support  string $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @support  string $sort_field 排序字段 
     * @support  bool $sort_desc 是否倒序 
     * @support  bool $with_del 是否需要删除数据 
     * @throws  \Exception
     * @return  array
     */
    public static function searchUseDb () {
        return self::getClass()->searchUseDb();
    }

    /**
     * 使用ES查询订单
     *
     * @support  array $order_ids 订单编号s 
     * @support  array $order_nos 订单ids 
     * @support  array $store_ids 门店ids 
     * @support  array $product_ids 产品ids 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  string $look_photo_reserve_time_start 看片预约开始时间 
     * @support  string $look_photo_reserve_time_end 看片预约结束时间 
     * @support  string $create_time_start 查询开始时间 
     * @support  string $create_time_end 查询结束时间 
     * @support  array $user_ids 绑定用户uids 
     * @support  string $status 订单状态 
     * @support  array $status_list 订单状态 
     * @support  string $pending_status 无纸化状态 
     * @support  array $pending_status_list 无纸化状态数组 
     * @support  string $user_name 下单用户 
     * @support  string $module 模块 
     * @support  string $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @support  string $sort_field 排序字段 
     * @support  bool $sort_desc 是否倒序 
     * @support  bool $with_del 是否需要删除数据 
     * @support  bool $is_pending_status pending_status是否为null 
     * @throws  \Exception
     * @return  array
     */
    public static function searchUseEs () {
        return self::getClass()->searchUseEs();
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @param  bool $withDelete 是否包含删除的订单 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id, bool $withDelete = false) {
        return self::getClass()->detail([
            "id" => $id,
            "withDelete" => $withDelete,
        ]);
    }

    /**
     * 订单详情【根据订单号获取】
     *
     * @param  string $order_no 订单号 [ require true ]
     * @param  bool $with_del 是否包含删除 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByOrderNo (string $order_no, bool $with_del = false) {
        return self::getClass()->detailByOrderNo([
            "order_no" => $order_no,
            "with_del" => $with_del,
        ]);
    }

    /**
     * 订单概念分主订单和子订单，主订单下面包含多个子订单，子订单分一销子订单和二销子订单。
     * 一销子订单不可以直接创建，主订单创建接口，隐含了对一销子订单的创建，因此在一个主订单下面，有且只有一条一销子订单。
     * 二销子订单可以有无限条，通过子订单创建接口直接创建
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $userId 用户ID 
     * @support  int $orderUserId 订单用户ID 
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户行吧 
     * @support  string $userBirthday 用户生日 
     * @support  string $userEmail 用户邮箱 
     * @support  string $from 订单来源（管理端、预约端） [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额（钱） [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  array $globalDiscountIds 全局优惠ID 
     * @support  float $globalDiscountMoney 全局优惠金额 [Original type double] 
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountNote 特殊折扣备注 
     * @support  float $giftCardMoney 礼品卡金额 [Original type double] 
     * @support  float $marketCardMoney 商场卡金额 [Original type double] 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $occupyNum 派单表占点数量 [ require true ]
     * @support  string $module 订单模块（himo，mantu） 
     * @support  string $type 订单类型（参考OrderTypeEnum） [ require true ]
     * @support  int $input_staff_id 伙伴ID 
     * @support  array $extend 订单extend 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 提交订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 创建并提交订单
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $userId 用户ID 
     * @support  int $orderUserId 订单用户ID 
     * @support  string $userName 用户名 
     * @support  string $userPhone 用户手机号 
     * @support  string $userSex 用户行吧 
     * @support  string $userBirthday 用户生日 
     * @support  string $userEmail 用户邮箱 
     * @support  string $from 订单来源（管理端、预约端） [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额（钱） [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  array $globalDiscountIds 全局优惠ID 
     * @support  float $globalDiscountMoney 全局优惠金额 [Original type double] 
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  string $discountNote 特殊折扣备注 
     * @support  float $giftCardMoney 礼品卡金额 [Original type double] 
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  int $occupyNum 派单表占点数量 [ require true ]
     * @support  string $module 订单模块（himo，mantu） 
     * @support  string $type 订单类型（参考OrderTypeEnum） [ require true ]
     * @support  int $input_staff_id 伙伴ID 
     * @support  array $extend 订单extend 
     * @throws  \Exception
     * @return  array
     */
    public static function createAndSubmit () {
        return self::getClass()->createAndSubmit();
    }

    /**
     * 删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id, int $operateId = 0) {
        return self::getClass()->remove([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @param  bool $fromPaymentGateway 来自支付网关 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, string $payType, int $operateId = 0, string $paymentNo = '', bool $fromPaymentGateway = false) {
        return self::getClass()->setPaid([
            "id" => $id,
            "payType" => $payType,
            "operateId" => $operateId,
            "paymentNo" => $paymentNo,
            "fromPaymentGateway" => $fromPaymentGateway,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id, int $operateId = 0) {
        return self::getClass()->start([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 当订单内有已经支付但是未关闭的子订单、或者退款处理中的子订单，均不符合关闭订单条件，禁止关单。
     * 可以完成前置条件后再调用此接口关单。
     * 该接口会清空工作量、取消排单表
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $id, string $reason, int $operateId = 0) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 关闭美团订单
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMeiTuanOrder (int $id) {
        return self::getClass()->closeMeiTuanOrder([
            "id" => $id,
        ]);
    }

    /**
     * 该接口会清空工作量、取消排单表
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeMantuOrder (int $id, string $reason = '', int $operateId = 0) {
        return self::getClass()->closeMantuOrder([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 完成订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  array $workloads 工作量数组，staff_id 伙伴ID，staff_type 伙伴类型，work_per 工作占比 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finish (int $id, array $workloads, int $operateId = 0) {
        return self::getClass()->finish([
            "id" => $id,
            "workloads" => $workloads,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 完成缦图订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $operateId 录单人 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishMantuOrder (int $orderId, int $operateId = 0) {
        return self::getClass()->finishMantuOrder([
            "orderId" => $orderId,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 完成看片（同时需要录入工作量）
     *
     * @param  int $orderId 订单ID [ require true ]
     * @param  int $staffId 伙伴ID [ require true ]
     * @param  int $workPer 工作量占比 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function completeLookPhoto (int $orderId, int $staffId = 0, int $workPer = 0) {
        return self::getClass()->completeLookPhoto([
            "orderId" => $orderId,
            "staffId" => $staffId,
            "workPer" => $workPer,
        ]);
    }

    /**
     * 服务整体完成（用户确认服务完成）
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function serviceComplete (int $id) {
        return self::getClass()->serviceComplete([
            "id" => $id,
        ]);
    }

    /**
     * 服务整体完成（系统确认服务完成）
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sysServiceComplete (int $id) {
        return self::getClass()->sysServiceComplete([
            "id" => $id,
        ]);
    }

    /**
     * 修改预约时间【未提交前】
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTimeWhenNoSubmit (int $id, string $reserveTime, int $operateId = 0) {
        return self::getClass()->changeReserveTimeWhenNoSubmit([
            "id" => $id,
            "reserveTime" => $reserveTime,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserveTime 预约时间 [ require true ]
     * @param  string $note 备注（如果填则记录） [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTime (int $id, string $reserveTime, int $operateId = 0, string $note = '') {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserveTime" => $reserveTime,
            "operateId" => $operateId,
            "note" => $note,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $userName 用户姓名 
     * @support  string $userSex 用户性别 
     * @support  string $userEmail 用户邮箱 
     * @support  string $userBirthday 用户生日 
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeUserData (int $operateId = 0) {
        return self::getClass()->changeUserData([
            "operateId" => $operateId,
        ]);
    }

    /**
     * 修改订单extend数据
     *
     * @support  int $id 订单ID 
     * @support  string $note 订单备注 
     * @support  string $no_paper_note 无纸化备注 
     * @support  int $modify_count 修改次数 
     * @support  int $operateId 录单人 
     * @support  int $reached_people_num 到店人数 
     * @support  string $part_refund_time 部分退款时间 
     * @support  string $appoint_look_photo_source 预约看片来源 user 用户预约端 store 门店端 
     * @throws  \Exception
     * @return  array
     */
    public static function changeExtend () {
        return self::getClass()->changeExtend();
    }

    /**
     * 恢复到等待拍摄状态
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id, int $operateId = 0) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 把完成的订单恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverFinishedToWaitShooting (int $id, int $operateId = 0) {
        return self::getClass()->recoverFinishedToWaitShooting([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 根据订单号获取订单ID
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getIdByNo (string $orderNo) {
        return self::getClass()->getIdByNo([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 根据订单ID获取订单号
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getNoById (int $id) {
        return self::getClass()->getNoById([
            "id" => $id,
        ]);
    }

    /**
     * 转门店只有没有二销的才可以，只会转一销
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @param  int $occupy_num 占点数 [Original type uint] [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeStore (int $id, int $store_id, string $reserve_time, int $operateId = 0, int $occupy_num = 0) {
        return self::getClass()->changeStore([
            "id" => $id,
            "store_id" => $store_id,
            "reserve_time" => $reserve_time,
            "operateId" => $operateId,
            "occupy_num" => $occupy_num,
        ]);
    }

    /**
     * 绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @param  string $userPhone 用户手机号 [ require true ]
     * @param  bool $force 强制绑定 [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $userId, string $userPhone, bool $force = false, int $operateId = 0) {
        return self::getClass()->bindUser([
            "id" => $id,
            "userId" => $userId,
            "userPhone" => $userPhone,
            "force" => $force,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 解绑用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id, int $operateId = 0) {
        return self::getClass()->unbindUser([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 用户删除订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $operateId 录单人 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function deleteByUser (int $id, int $operateId = 0) {
        return self::getClass()->deleteByUser([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * TODO 该接口暂时没有过滤掉加修加印等不需要云端上传照片的服务
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrder (string $orderNo = NULL, int $orderId = NULL) {
        return self::getClass()->getProductsInOrder([
            "orderNo" => $orderNo,
            "orderId" => $orderId,
        ]);
    }

    /**
     * TODO 该接口暂时没有过滤掉加修加印等不需要云端上传照片的服务
     *
     * @param  array $orderNos 订单号数组 [ require true ]
     * @param  array $orderIds 订单ID数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInOrders (array $orderNos = NULL, array $orderIds = NULL) {
        return self::getClass()->getProductsInOrders([
            "orderNos" => $orderNos,
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 根据订单号批量获取订单下面买的产品
     *
     * @param  array $orderNos 订单号数组 [ require true ]
     * @param  array $orderIds 订单ID数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductsInfoInOrders (array $orderNos = NULL, array $orderIds = NULL) {
        return self::getClass()->getProductsInfoInOrders([
            "orderNos" => $orderNos,
            "orderIds" => $orderIds,
        ]);
    }

    /**
     * 批量更新订单的发票ID
     *
     * @param  int $invoice_id 发票ID [ require true ]
     * @param  array $order_nos 订单号数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateInvoiceId (int $invoice_id, array $order_nos) {
        return self::getClass()->batchUpdateInvoiceId([
            "invoice_id" => $invoice_id,
            "order_nos" => $order_nos,
        ]);
    }

    /**
     * 缦图订单付首款
     *
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  int $id 订单ID [ require true ]
     * @support  string $pay_mode 全款还是部分付款，参考SubOrderPayModeEnum [ require true ]
     * @support  string $payment_no 支付流水号，非必填 
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuOrderFirstPay () {
        return self::getClass()->mantuOrderFirstPay();
    }

    /**
     * 缦图订单付尾款
     *
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  int $id 订单ID [ require true ]
     * @support  float $money 尾款金额 [Original type double] [ require true ]
     * @support  string $payment_no 支付流水号，非必填 
     * @throws  \Exception
     * @return  mixed
     */
    public static function mantuOrderFinalPay () {
        return self::getClass()->mantuOrderFinalPay();
    }

    /**
     * 自动关闭一个小时之外的订单(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function onTimeCloseOrder () {
        return self::getClass()->onTimeCloseOrder();
    }

    /**
     * 计算订单消费金额
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getOrderConsumeMoney (int $order_id) {
        return self::getClass()->getOrderConsumeMoney([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取门店下订单不同状态数量【专供缦图订单接口】
     *
     * @param  int $storeId 门店iD [ require true ]
     * @param  string $module 模块 [ require true ]
     * @param  bool $needToday 是否仅需要当天数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderStatus (int $storeId, string $module, bool $needToday = false) {
        return self::getClass()->getOrderStatus([
            "storeId" => $storeId,
            "module" => $module,
            "needToday" => $needToday,
        ]);
    }

    /**
     * TODO 这部分代码，有时间的时候优化一下，暂时先复制之前的稍作修改
     *
     * @support  int $dsModel 查询类型 1：共享 2：主推 
     * @support  int $staffId 伙伴id [ require true ]
     * @support  int $storeId 门店id 
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @throws  \Exception
     * @return  array
     */
    public static function queryDsListWithStore () {
        return self::getClass()->queryDsListWithStore();
    }

    /**
     * 查看订单操作日志
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderOperateLog (int $orderId) {
        return self::getClass()->getOrderOperateLog([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 看片自动确认
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function autoConfirm (int $id) {
        return self::getClass()->autoConfirm([
            "id" => $id,
        ]);
    }

    /**
     * 看片自动确认标记清除
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearConfirmation (int $id) {
        return self::getClass()->clearConfirmation([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单id查询看片完成信息
     *
     * @param  array $ids 订单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getConfirmationByIds (array $ids) {
        return self::getClass()->getConfirmationByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 改变订单的看片预约时间
     *
     * @param  int $id 订单id [ require true ]
     * @support  string $look_photo_reserve_time 看片预约时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeLookPhotoReserveTime (int $id) {
        return self::getClass()->changeLookPhotoReserveTime([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}