<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemsDetailByIdsByParams(array $params)
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method closePaidByParams(array $params)
 * @method storeRemovePaidSubOrderByParams(array $params)
 * @method submitByParams(array $params)
 * @method useGiftCardMoneyPayByParams(array $params)
 * @method cancelByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method modifyMoneyByParams(array $params)
 * @method getOrderItemUpgradeByParams(array $params)
 * @method visaChangeByParams(array $params)
 */
class SubOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 子订单列表
     *
     * @support  array $order_nos 子订单编号 
     * @support  string $type 订单类型：order,ds 
     * @support  string $pay_type 支付类型，同子订单支付类型 
     * @support  string $status 状态 
     * @support  array $status_list 状态列表 
     * @support  int $store_id 门店ID 
     * @support  string $paid_at_start 支付时间起始 
     * @support  string $paid_at_end 支付时间结束 
     * @support  string $page_size  
     * @support  string $page  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 子订单详情
     *
     * @param  int $id 子订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取子订单产品项详情
     *
     * @param  array $sub_order_ids 子订单IDS [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemsDetailByIds (array $sub_order_ids) {
        return self::getClass()->itemsDetailByIds([
            "sub_order_ids" => $sub_order_ids,
        ]);
    }

    /**
     * 子订单创建接口默认隐含了二销的含义，即通过此接口创建的子订单为二销子订单
     *
     * @support  int $orderId 主订单ID [ require true ]
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额（钱） [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  string $dsType 二销类型 
     * @support  array $globalDiscountIds 全局优惠ID 
     * @support  float $globalDiscountMoney 全局优惠金额 [Original type double] 
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $specialDiscountMoney 特殊折扣金额 [Original type double] 
     * @support  float $giftCardMoney 礼品卡金额 [Original type double] 
     * @support  int $inputStaffId 主推人 
     * @support  int $operateId 录入伙伴ID 
     * @support  int $upgradeId 升级体验父级项id 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 移除子订单
     *
     * @param  int $id 子订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 关闭子订单，并且创建关闭流水（仅限原因为pay的income流水）冲销支付流水
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $reason 关闭原因 [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closePaid (int $id, string $reason = '', int $operateId = 0) {
        return self::getClass()->closePaid([
            "id" => $id,
            "reason" => $reason,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 门店删除已支付的子订单，子订单关闭，并且创建关闭流水（仅限原因为pay的income流水）冲销支付流水
     * 注意：该动作不触发关闭主订单操作
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  int $operateId 操作人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeRemovePaidSubOrder (int $id, int $operateId = 0) {
        return self::getClass()->storeRemovePaidSubOrder([
            "id" => $id,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 提交子订单
     *
     * @param  int $id 子订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 本接口对已经提交了，但是出于待支付状态的子订单，使用礼品卡进行支付（预付）。
     * 本接口适应场景：当管理端开单，订单已经提交，即将进行下一步支付的时候，可以修改支付金额，选择全部或者部分金额使用礼品卡支付。
     * 调用本接口时，会修改当前订单的礼品卡支付金额为目标金额，实付金额为原实付金额减去礼品卡支付金额，并对礼品卡金额发起礼品卡预支付。
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  float $gift_card_money 使用礼品卡支付的金额 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useGiftCardMoneyPay (int $id, float $gift_card_money) {
        return self::getClass()->useGiftCardMoneyPay([
            "id" => $id,
            "gift_card_money" => $gift_card_money,
        ]);
    }

    /**
     * 取消子订单
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason = '') {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 设置子订单完成支付
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, string $payType, string $paymentNo = '') {
        return self::getClass()->setPaid([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 修改子订单支付方式
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @param  int $operateId 操作人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changePayType (int $id, string $pay_type, string $payment_no = '', int $operateId = 0) {
        return self::getClass()->changePayType([
            "id" => $id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
            "operateId" => $operateId,
        ]);
    }

    /**
     * 订单创建后的改价格。
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $real_money 支付金额 [Original type double] [ require true ]
     * @param  float $gift_card_money 礼品卡金额 [Original type double] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyMoney (int $id, float $real_money, float $gift_card_money) {
        return self::getClass()->modifyMoney([
            "id" => $id,
            "real_money" => $real_money,
            "gift_card_money" => $gift_card_money,
        ]);
    }

    /**
     * 获取子订单产品升级服务
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderItemUpgrade (int $orderId) {
        return self::getClass()->getOrderItemUpgrade([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 签证/同类互换
     *
     * @support  int $subOrderId 子订单号 [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID 
     * @support  array $detail 产品详情 [ require true ]
     * @support  int $refundItemId 退款项id [ require true ]
     * @support  int $serviceId 退款项服务id 
     * @support  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function visaChange () {
        return self::getClass()->visaChange();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'SubOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'SubOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}