<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method fixNoPayByParams(array $params)
 * @method changeOrderStatusByParams(array $params)
 */
class Fix {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用来处理用户确实付了钱，但是支付通知失败的场景。
     * 需要提供主订单号、支付流水号、支付类型
     * 支付时间取近似时间（子订单提交时间，或创建时间）
     * 流水创建时间取支付时间
     * 如需通过url访问，配置RpcApi注解
     *
     * @support  string $no 主订单号 [ require true ]
     * @support  string $payment_no 支付流水号 [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  string $reserve_time 预约时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixNoPay () {
        return self::getClass()->fixNoPay();
    }

    /**
     * 该接口修改订单状态，但是仅限于修复某些特殊情况.
     * 该操作只会简单改变订单数据的状态，而不处理状态变更相应的逻辑
     *
     * @support  string $order_no 订单号 
     * @support  int $id 订单ID 
     * @support  string $status 订单状态 [ require true ]
     * @support  string $closed_at 订单关闭时间（仅在修改为退款关闭时有用） 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeOrderStatus () {
        return self::getClass()->changeOrderStatus();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Fix');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Fix');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}