<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method fixNoPayByParams(array $params)
 */
class Fix {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用来处理用户确实付了钱，但是支付通知失败的场景。
     * 需要提供主订单号、支付流水号、支付类型
     * 支付时间取近似时间（子订单提交时间，或创建时间）
     * 流水创建时间取支付时间
     * 如需通过url访问，配置RpcApi注解
     *
     * @support  string $no 主订单号 [ require true ]
     * @support  string $payment_no 支付流水号 [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixNoPay () {
        return self::getClass()->fixNoPay();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Fix');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Fix');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}