<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method getQueueCountByParams(array $params)
 * @method getLastQueueSortByParams(array $params)
 */
class OrderQueue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取最后一条队列的排序号
     *
     * @support  string $pending_status 队列状态 
     * @support  int $store_id 门店id 
     * @support  bool $nullable_staff staff为空 
     * @support  int $staff_id 伙伴id 
     * @support  int $order_id 订单id 
     * @support  bool $skip_make_up 跳过化妆 
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 获取相关的数量
     *
     * @support  string $pending_status 队列状态 
     * @support  int $store_id 门店id 
     * @support  bool $nullable_staff staff为空 
     * @support  int $staff_id 伙伴id 
     * @support  int $order_id 订单id 
     * @support  bool $skip_make_up 跳过化妆 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getQueueCount () {
        return self::getClass()->getQueueCount();
    }

    /**
     * 获取最后一条队列的排序号
     *
     * @support  string $pending_status 队列状态 
     * @support  int $store_id 门店id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastQueueSort () {
        return self::getClass()->getLastQueueSort();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OrderQueue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OrderQueue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}