<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByOrderIdByParams(array $params)
 * @method listByParams(array $params)
 * @method onTimePassTempRefundByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单子项
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listByOrderId (int $order_id) {
        return self::getClass()->listByOrderId([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 退款列表
     *
     * @support  array $orderIds 主订单ID 
     * @support  string $status 状态 
     * @support  int $storeId 门店ID 
     * @support  string $applyTimeStart 申请时间-开始 
     * @support  string $applyTimeEnd 申请时间-结束 
     * @support  string $processTimeStart 处理时间-开始 
     * @support  string $processTimeEnd 处理时间-结束 
     * @support  int $page  
     * @support  int $pageSize  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 自动处理一小时内的临时退款(定时任务)
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function onTimePassTempRefund () {
        return self::getClass()->onTimePassTempRefund();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}