<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method fixByParams(array $params)
 * @method fixNoPayByParams(array $params)
 * @method refundGiftCardByParams(array $params)
 * @method cancelGiftCardPayByParams(array $params)
 * @method confirmSubOrderByParams(array $params)
 * @method refundCouponByParams(array $params)
 */
class Fix {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * fix
     *
     * @support  string $no no [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fix () {
        return self::getClass()->fix();
    }

    /**
     * fixNoPay
     *
     * @support  string $no no [ require true ]
     * @support  string $payment_no 支付流水号 [ require true ]
     * @support  string $pay_type 支付类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixNoPay () {
        return self::getClass()->fixNoPay();
    }

    /**
     * refundGiftCard
     *
     * @support  string $no no [ require true ]
     * @support  string $payment_no 礼品卡支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundGiftCard () {
        return self::getClass()->refundGiftCard();
    }

    /**
     * cancelGiftCardPay
     *
     * @support  string $payment_no 礼品卡支付流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelGiftCardPay () {
        return self::getClass()->cancelGiftCardPay();
    }

    /**
     * confirmSubOrder
     *
     * @support  string $no no [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmSubOrder () {
        return self::getClass()->confirmSubOrder();
    }

    /**
     * refundCoupon
     *
     * @support  string $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundCoupon () {
        return self::getClass()->refundCoupon();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Fix');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Fix');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}