<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSnPaperByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSnByOrderIdByParams(array $params)
 * @method submitSnResultByParams(array $params)
 * @method listByParams(array $params)
 */
class Sn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取sn问卷（含题目、选项）
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSnPaper () {
        return self::getClass()->getSnPaper();
    }

    /**
     * 获取sn详情
     *
     * @param  int $id ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据订单ID获取该订单的SN问卷
     *
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSnByOrderId (int $orderId) {
        return self::getClass()->getSnByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 提交SN问卷
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  int $storeId 门店ID [ require true ]
     * @support  string $userName 用户名 [ require true ]
     * @support  string $userTel 用户手机号 [ require true ]
     * @support  array $answers 答案组 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitSnResult () {
        return self::getClass()->submitSnResult();
    }

    /**
     * 查询Sn问卷数据
     *
     * @support  int $storeId 门店id [ require true ]
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'Sn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'Sn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}