<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method simpleListByParams(array $params)
 */
class NoPaperWorkflowLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 无纸化工作流日志列表
     *
     * @support  int $staff_id 伙伴id 
     * @support  int $store_id 门店id 
     * @support  int $order_id 订单id 
     * @support  array $order_ids 订单ids 
     * @support  string $pending_status 无纸化状态 
     * @support  array $pending_status_in 无纸化状态数组 
     * @support  array $order_id_in order id in 
     * @support  array $order_id_not_in order id not in 
     * @support  bool $with_order 带上order记录 
     * @support  string $order_by_desc 按字段倒序 
     * @support  string $updated_start_at 开始时间 
     * @support  string $updated_end_at 结束时间 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 无纸化工作流日志列表(不带count和pages)
     *
     * @support  int $staff_id 伙伴id 
     * @support  int $store_id 门店id 
     * @support  int $order_id 订单id 
     * @support  array $order_ids 订单ids 
     * @support  string $pending_status 无纸化状态 
     * @support  array $pending_status_in 无纸化状态数组 
     * @support  array $order_id_in order id in 
     * @support  array $order_id_not_in order id not in 
     * @support  bool $with_order 带上order记录 
     * @support  string $order_by_desc 按字段倒序 
     * @support  string $updated_start_at 开始时间 
     * @support  string $updated_end_at 结束时间 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function simpleList () {
        return self::getClass()->simpleList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'NoPaperWorkflowLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'NoPaperWorkflowLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}