<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method closePaidByParams(array $params)
 * @method submitByParams(array $params)
 * @method cancelByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method modifyMoneyByParams(array $params)
 */
class SubOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 子订单列表
     *
     * @support  string $type 订单类型：order,ds 
     * @support  string $pay_type 支付类型，同子订单支付类型 
     * @support  string $status 状态 
     * @support  int $store_id 门店ID 
     * @support  string $paid_at_start 支付时间起始 
     * @support  string $paid_at_end 支付时间结束 
     * @support  string $page_size  
     * @support  string $page  
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 子订单详情
     *
     * @param  int $id 子订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 子订单创建接口默认隐含了二销的含义，即通过此接口创建的子订单为二销子订单
     *
     * @support  int $orderId 主订单ID [ require true ]
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  float $realMoney 订单实付金额（钱） [Original type double] [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  array $globalDiscountIds 全局优惠ID 
     * @support  float $globalDiscountMoney 全局优惠金额 [Original type double] 
     * @support  string $interiorCouponCode 开单折扣码UUID 
     * @support  float $interiorCouponDeductionMoney 开单折扣码抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券抵扣金额 [Original type double] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡抵扣金额 [Original type double] 
     * @support  float $giftCardMoney 礼品卡金额 [Original type double] 
     * @support  int $inputStaffId 录入伙伴ID 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 移除子订单
     *
     * @param  int $id 子订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 关闭子订单，并且创建关闭流水（仅限原因为pay的income流水）冲销支付流水
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $reason 删除原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closePaid (int $id, string $reason) {
        return self::getClass()->closePaid([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 提交子订单
     *
     * @param  int $id 子订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 取消子订单
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason = '') {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 设置子订单完成支付
     *
     * @param  int $id 子订单ID [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, string $payType, string $paymentNo = '') {
        return self::getClass()->setPaid([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 修改子订单支付方式
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @param  string $payment_no 支付流水号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changePayType (int $id, string $pay_type, string $payment_no = '') {
        return self::getClass()->changePayType([
            "id" => $id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 订单创建后的改价格。
     * TODO 提交前改还是提交后改，需要跟运营确定。如果是提交后改，则不能改礼品卡支付价格。如果需要要支持改礼品卡支付价格，能么最好在提交前改。
     *
     * @param  int $id 订单id [ require true ]
     * @param  bool $money 金额 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function modifyMoney (int $id, bool $money) {
        return self::getClass()->modifyMoney([
            "id" => $id,
            "money" => $money,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'SubOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'SubOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}