<?php
namespace Mainto\Bridge\Invokes\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method removeByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 */
class OtherOrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 退款列表
     *
     * @support  int $page  
     * @support  int $page_size  
     * @support  string $order_id 订单ID 
     * @support  int $store_id 门店ID 
     * @support  string $status 状态 
     * @support  string $type 类型 
     * @support  string $created_at_start 创建时间-开始 
     * @support  string $created_at_end 创建时间-结束 
     * @support  string $passed_at_start 通过时间-开始 
     * @support  string $passed_at_end 通过时间-结束 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 退款详情
     *
     * @param  int $id 线下订单退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 创建退款
     *
     * @support  int $order_id 订单ID [ require true ]
     * @support  string $order_no 订单号 
     * @support  int $store_id 门店ID 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  string $reason 退款原因 [ require true ]
     * @support  string $type 类型 
     * @support  string $note 备注 
     * @support  int $input_staff_id 录入人伙伴ID 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 删除退款
     *
     * @param  int $id 线下订单退款ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 通过退款
     *
     * @param  int $id 线下订单退款ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function pass (int $id) {
        return self::getClass()->pass([
            "id" => $id,
        ]);
    }

    /**
     * 拒绝退款
     *
     * @param  int $id 线下订单退款ID [ require true ]
     * @param  string $reason 拒绝理由 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reject (int $id, string $reason = NULL) {
        return self::getClass()->reject([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('Order', 'OtherOrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('Order', 'OtherOrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}